<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Assignment extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/assignment_model');
        $this->load->model('hr/candidate_model');
    }

    public function index()
    {
        $data['title'] = _l('hr_assignments');
        $data['assignments'] = $this->assignment_model->all();
        $this->load->view('assignments/manage', $data);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $assignmentData = [
                'candidate_id' => (int)($post['candidate_id'] ?? 0),
                'title' => trim($post['title'] ?? ''),
                'description' => trim($post['description'] ?? ''),
                'file_path' => trim($post['file_path'] ?? ''),
                'status' => 'pending',
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/assignment/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'assignment_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $assignmentData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $assignmentData['file_path'] = '';
                }
            } else {
                $assignmentData['file_path'] = '';
            }

            $id = $this->assignment_model->add($assignmentData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_assignment')));
            }
            redirect(admin_url('hr/assignment'));
        }

        $data['title'] = _l('hr_new_assignment');
        $data['candidates'] = $this->candidate_model->all();
        $this->load->view('assignments/add_edit', $data);
    }

    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $assignmentData = [
                'candidate_id' => (int)($post['candidate_id'] ?? 0),
                'title' => trim($post['title'] ?? ''),
                'description' => trim($post['description'] ?? ''),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/assignment/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'assignment_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $assignmentData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $assignmentData['file_path'] = '';
                }
            }

            $success = $this->assignment_model->update($id, $assignmentData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_assignment')));
            }
            redirect(admin_url('hr/assignment'));
        }

        $data['assignment'] = $this->assignment_model->get($id);
        if (!$data['assignment']) {
            show_404();
        }
        $data['title'] = _l('hr_edit_assignment');
        $data['candidates'] = $this->candidate_model->all();
        $this->load->view('assignments/add_edit', $data);
    }

    public function delete($id)
    {
        $this->assignment_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_assignment')));
        redirect(admin_url('hr/assignment'));
    }

    public function approve($id)
    {
        $this->assignment_model->approve($id);
        set_alert('success', _l('hr_assignment_approved'));
        redirect(admin_url('hr/assignment'));
    }

    public function reject($id)
    {
        $this->assignment_model->reject($id);
        set_alert('success', _l('hr_assignment_rejected'));
        redirect(admin_url('hr/assignment'));
    }

    public function download($id)
    {
        $assignment = $this->assignment_model->get($id);
        if ($assignment && $assignment->file_path) {
            $file_path = FCPATH . $assignment->file_path;
            if (file_exists($file_path)) {
                force_download($file_path, null);
            } else {
                set_alert('danger', _l('file_not_found'));
            }
        } else {
            set_alert('danger', _l('assignment_not_found'));
        }
        redirect(admin_url('hr/assignment'));
    }
}
