<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_contract_model extends CI_Model
{
    protected $table = 'tblhr_candidate_contracts';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get all contracts or specific by ID
     */
    public function get($id = null)
    {
        if ($id) {
            return $this->db->where('id', $id)->get($this->table)->row();
        }
        return $this->db->get($this->table)->result();
    }

    /**
     * Insert new contract
     */
    public function insert($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Update contract by ID
     */
    public function update($id, $data)
    {
        return $this->db->where('id', $id)->update($this->table, $data);
    }

    /**
     * Delete contract by ID
     */
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete($this->table);
    }

    /**
     * Get contracts by candidate_id
     */
    // public function get_by_candidate($candidate_id)
    // {
    //     return $this->db->where('candidate_id', $candidate_id)->get($this->table)->result();
    // }

    public function get_by_contract_id($contract_id)
    {
        return $this->db->where('contract_id', $contract_id)
                        ->get('tblhr_candidate_contracts')
                        ->row();
    }


}
