<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/assignment/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_assignment'); ?>
                    </a>
                    <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default">
                        <?php echo _l('hr_candidates'); ?>
                    </a>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-assignments">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo _l('hr_assignment_title'); ?></th>
                                    <th><?php echo _l('hr_candidate'); ?></th>
                                    <th><?php echo _l('hr_status'); ?></th>
                                    <th><?php echo _l('hr_submitted_at'); ?></th>
                                    <th><?php echo _l('hr_approved_at'); ?></th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; ?>
                                <?php foreach ($assignments as $row) { ?>
                                    <tr>
                                        <td><?php echo e($i); ?></td>
                                        <td><?php echo e($row['title']); ?></td>
                                        <td><?php echo e($row['first_name'] . ' ' . $row['last_name'] ?? 'N/A'); ?></td>
                                        <td><span class="label label-default"><?php echo e(ucfirst($row['status'])); ?></span></td>
                                        <td><?php echo e($row['submitted_at'] ? _d($row['submitted_at']) : '-'); ?></td>
                                        <td><?php echo e($row['approved_at'] ? _d($row['approved_at']) : '-'); ?></td>
                                        <td class="text-right">
                                            <?php if ($row['status'] == 'submitted') { ?>
                                                <a href="<?php echo admin_url('hr/assignment/approve/' . $row['id']); ?>" class="btn btn-success btn-icon" title="<?php echo _l('hr_approve'); ?>"><i class="fa-regular fa-check"></i></a>
                                                <a href="<?php echo admin_url('hr/assignment/reject/' . $row['id']); ?>" class="btn btn-danger btn-icon" title="<?php echo _l('hr_reject'); ?>"><i class="fa-regular fa-times"></i></a>
                                            <?php } ?>
                                            <?php if ($row['file_path']) { ?>
                                                <a href="<?php echo admin_url('hr/assignment/download/' . $row['id']); ?>" class="btn btn-info btn-icon" title="<?php echo _l('download'); ?>"><i class="fa-regular fa-download"></i></a>
                                            <?php } ?>
                                            <a href="<?php echo admin_url('hr/assignment/edit/' . $row['id']); ?>" class="btn btn-default btn-icon" title="<?php echo _l('edit'); ?>"><i class="fa-regular fa-pen-to-square"></i></a>
                                            <a href="<?php echo admin_url('hr/assignment/delete/' . $row['id']); ?>" class="btn btn-danger btn-icon _delete" title="<?php echo _l('delete'); ?>"><i class="fa-regular fa-trash-can"></i></a>
                                        </td>
                                    </tr>
                                <?php $i++; ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
