<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/contract_model');
        $this->load->model('hr/candidate_model');
    }

    public function index()
    {
        $filters = [];
        if($this->input->get('status')){
            $filters = [
                'cc.status' => $this->input->get('status')
            ];
        }
        
        $data['title'] = _l('hr_contracts');
        $data['contracts'] = $this->contract_model->all($filters);
        $this->load->view('contracts/manage', $data);
    }
    public function get_status($id){
        
        $this->load->model('contract_model');
        $record = $this->contract_model->get_by_id($id);
        echo json_encode($record);
    }

    public function update_status(){
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $date = $this->input->post('date');

        $this->load->model('candidate_contract_model');
        $updated = $this->candidate_contract_model->update($id, ['status' => $status, 'date' => $date]);

        echo json_encode(['success' => $updated]);
    }

    public function bulk_update_status(){
        $status = $this->input->post('status');
        $contract_ids = json_decode($this->input->post('contract_ids'), true);
        
        if (empty($contract_ids) || !is_array($contract_ids)) {
            echo json_encode(['success' => false, 'message' => 'No contracts selected']);
            return;
        }
        
        if (!in_array($status, ['approved', 'rejected'])) {
            echo json_encode(['success' => false, 'message' => 'Invalid status']);
            return;
        }
        
        $this->load->model('candidate_contract_model');
        $updated_count = 0;
        
        foreach ($contract_ids as $id) {
            $updated = $this->candidate_contract_model->update($id, ['status' => $status]);
            if ($updated) {
                $updated_count++;
            }
        }
        
        echo json_encode([
            'success' => $updated_count > 0,
            'updated_count' => $updated_count,
            'message' => $updated_count > 0 ? 'Contracts updated successfully' : 'No contracts were updated'
        ]);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'candidate_id' => (int)($post['candidate_id'] ?? null),
                'title' => trim($post['title'] ?? ''),
                'contract_type' => trim($post['contract_type'] ?? 'employment'),
                'start_date' => trim($post['start_date'] ?? null),
                'end_date' => trim($post['end_date'] ?? null),
                'salary' => $post['salary'] !== '' ? (float)$post['salary'] : null,
                'currency' => trim($post['currency'] ?? ''),
                'status' => trim($post['status'] ?? 'draft'),
                'file_path' => trim($post['file_path'] ?? ''),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/contract/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'contract_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $contractData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $contractData['file_path'] = '';
                }
            } else {
                $contractData['file_path'] = '';
            }

            $id = $this->contract_model->add($contractData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract'));
        }

        $data['title'] = _l('hr_new_contract');
        $data['candidates_kv'] = array_column($this->candidate_model->all(), 'first_name', 'id');
        $this->load->view('contracts/add_edit', $data);
    }

    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'candidate_id' => (int)($post['candidate_id'] ?? null),
                'title' => trim($post['title'] ?? ''),
                'contract_type' => trim($post['contract_type'] ?? 'employment'),
                'start_date' => trim($post['start_date'] ?? null),
                'end_date' => trim($post['end_date'] ?? null),
                'salary' => $post['salary'] !== '' ? (float)$post['salary'] : null,
                'currency' => trim($post['currency'] ?? ''),
                'status' => trim($post['status'] ?? 'draft'),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/contract/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'contract_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $contractData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $contractData['file_path'] = '';
                }
            }

            $success = $this->contract_model->update($id, $contractData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract'));
        }

        $data['contract'] = $this->contract_model->get($id);
        if (!$data['contract']) {
            show_404();
        }
        $data['title'] = _l('hr_edit_contract');
        $data['candidates_kv'] = array_column($this->candidate_model->all(), 'first_name', 'id');
        $this->load->view('contracts/add_edit', $data);
    }

    public function delete($id)
    {
        $this->contract_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_contract')));
        redirect(admin_url('hr/contract'));
    }
}
