<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract_template extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/contract_template_model');
    }

    public function index()
    {
        $data['title'] = _l('hr_contracts');
        $data['contracts'] = $this->contract_template_model->all();
        $this->load->view('contract_template/manage', $data);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'title' => trim($post['title'] ?? ''),
                'details' => trim($post['details'] ?? ''),
                'created_by' => get_staff_user_id(),
            ];

            // List of file input names
            $fileInputs = ['cover_image', 'background_image', 'last_image'];

            // Upload directory
            $uploadPath = FCPATH . 'uploads/hr/contract_template/';

            // Ensure the folder exists
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }

            // Loop through each input
            foreach ($fileInputs as $inputName) {
                if (!empty($_FILES[$inputName]['name'])) {

                    $config['upload_path']   = $uploadPath;
                    // ✅ Allow only JPG & PNG
                    $config['allowed_types'] = 'jpg|jpeg|png';
                    $config['max_size']      = 2048; // 2MB
                    $config['file_name']     = $inputName . '_' . time() . '_' . $_FILES[$inputName]['name'];

                    $this->load->library('upload', $config);

                    if ($this->upload->do_upload($inputName)) {
                        $uploadData = $this->upload->data();
                        $contractData[$inputName] = $uploadData['file_name'];
                    } else {
                        set_alert('warning', ucfirst(str_replace('_', ' ', $inputName)) . ' upload failed: ' . $this->upload->display_errors());
                        $contractData[$inputName] = '';
                    }

                } else {
                    $contractData[$inputName] = '';
                }
            }

            $id = $this->contract_template_model->add($contractData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract_template'));
        }

        $data['title'] = _l('hr_new_contract');
        $this->load->view('contract_template/add_edit', $data);
    }
    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);

            // collect dynamic fields
            $labels = $post['field_label'] ?? [];
            $values = $post['field_value'] ?? [];

            $fields = [];
            if (!empty($labels)) {
                foreach ($labels as $i => $label) {
                    $fields[] = [
                        'label' => $label,
                        'value' => $values[$i] ?? null,
                    ];
                }
            }

            $contractData = [
                'title'       => trim($post['title'] ?? ''),
                'details'     => trim($post['details'] ?? ''),
                'fields_list' => json_encode($fields), // store JSON in fields_list
            ];

            // List of file input names
            $fileInputs = ['cover_image', 'background_image', 'last_image'];

            // Upload directory
            $uploadPath = FCPATH . 'uploads/hr/contract_template/';

            // Ensure the folder exists
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }

            // Loop through each input
            foreach ($fileInputs as $inputName) {
                if (!empty($_FILES[$inputName]['name'])) {

                    $config['upload_path']   = $uploadPath;
                    // ✅ Allow only JPG & PNG
                    $config['allowed_types'] = 'jpg|jpeg|png';
                    $config['max_size']      = 2048; // 2MB
                    $config['file_name']     = $inputName . '_' . time() . '_' . $_FILES[$inputName]['name'];

                    $this->load->library('upload', $config);

                    if ($this->upload->do_upload($inputName)) {
                        $uploadData = $this->upload->data();
                        $contractData[$inputName] = $uploadData['file_name'];
                    } else {
                        set_alert('warning', ucfirst(str_replace('_', ' ', $inputName)) . ' upload failed: ' . $this->upload->display_errors());
                        $contractData[$inputName] = '';
                    }

                } else {
                    $contractData[$inputName] = '';
                }
            }

            $success = $this->contract_template_model->update($id, $contractData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract_template'));
        }

        $data['contract_template'] = $this->contract_template_model->get($id);
        if (!$data['contract_template']) {
            show_404();
        }

        // decode fields_list for editing
        $data['contract_template_fields'] = [];
        if (!empty($data['contract_template']->fields_list)) {
            $data['contract_template_fields'] = json_decode($data['contract_template']->fields_list);
        }

        $data['title'] = _l('hr_edit_contract');
        $this->load->view('contract_template/add_edit', $data);
    }



    public function delete($id)
    {
        $this->contract_template_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_contract')));
        redirect(admin_url('hr/contract_template'));
    }
}
