<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_select('candidate_id', array_map(function($candidate){return ['id'=>$candidate['id'],'name'=>$candidate['first_name'].' '.$candidate['last_name']];}, $candidates), ['id','name'], _l('hr_candidate'), isset($assignment) ? $assignment->candidate_id : ''); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_input('title', _l('hr_assignment_title'), isset($assignment) ? $assignment->title : ''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('description', _l('hr_assignment_description'), isset($assignment) ? $assignment->description : '', ['rows' => 4]); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="file_path" class="control-label"><?= _l('hr_assignment_file'); ?></label>
                                    <input type="file" name="file_path" class="form-control" id="file_path">
                                </div>
                                <?php // echo render_input('file_path', _l('hr_assignment_file'), isset($assignment) ? $assignment->file_path : ''); ?>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
