<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                
                <div class="panel_s">
                    <div class="panel-body">
                        <?php if ($certificate) { ?>
                            <div class="alert alert-success">
                                <h4><i class="fa fa-check-circle"></i> <?php echo _l('hr_certificate_valid'); ?></h4>
                                <p><strong><?php echo _l('hr_certificate_number'); ?>:</strong> <?php echo e($certificate->certificate_number); ?></p>
                                <p><strong><?php echo _l('hr_certificate_type'); ?>:</strong> <?php echo e($certificate->certificate_type); ?></p>
                                <p><strong><?php echo _l('hr_issued_at'); ?>:</strong> <?php echo e($certificate->issued_at ? _d($certificate->issued_at) : '-'); ?></p>
                                <p><strong><?php echo _l('hr_status'); ?>:</strong> <span class="label label-success"><?php echo e(ucfirst($certificate->status)); ?></span></p>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-danger">
                                <h4><i class="fa fa-times-circle"></i> <?php echo _l('hr_certificate_invalid'); ?></h4>
                                <p><?php echo _l('hr_certificate_not_found'); ?></p>
                            </div>
                        <?php } ?>
                        
                        <div class="mtop20">
                            <a href="<?php echo admin_url('hr/certification/validate'); ?>" class="btn btn-primary">
                                <i class="fa fa-search"></i> <?php echo _l('hr_validate_another'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
