<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_input('title', _l('hr_contract_title'), isset($contract_template) ? $contract_template->title : ''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('details', _l('Details'), isset($contract_template) ? $contract_template->details : '', ['rows' => 10], [], '', 'tinymce'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <h5>Dynamic Fields</h5>
                                <a href="javascript:void(0);" class="btn btn-primary" id="add_field">Add Field</a>
                                <div id="dynamic_fields">
                                    <?php
                                    if(isset($contract_template_fields)){
                                        foreach ($contract_template_fields as $key => $field){
                                            ?>
                                            <div class="row mb-2 dynamic_row" style="margin-top: 20px; margin-bottom: 20px;">
                                                <div class="col-md-5">
                                                    <input type="text" name="field_label[]" class="form-control" placeholder="Label" value="<?= $field->label ?>">
                                                </div>
                                                <div class="col-md-5">
                                                    <select name="field_value[]" class="form-control">
                                                        <option value="text" <?= $field->value == 'text' ? 'selected' : '' ?>>Text</option>
                                                        <option value="date" <?= $field->value == 'date' ? 'selected' : '' ?>>Date</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <a href="javascript:void(0);" class="btn btn-danger remove_field">Remove</a>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cover_image" class="control-label"><?= _l('Cover Image'); ?></label>
                                    <input type="file" name="cover_image" class="form-control" id="cover_image">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="background_image" class="control-label"><?= _l('Background Image'); ?></label>
                                    <input type="file" name="background_image" class="form-control" id="background_image">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="last_image" class="control-label"><?= _l('Last Image'); ?></label>
                                    <input type="file" name="last_image" class="form-control" id="last_image">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/contract'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
    jQuery(document).ready(function($){
    // Add new field
    $("#add_field").click(function(){
        let html = '<div class="row mb-2 dynamic_row" style="margin-top: 20px; margin-bottom: 20px;">' +
                        '<div class="col-md-5">' +
                            '<input type="text" name="field_label[]" class="form-control" placeholder="Label">' +
                        '</div>' +
                        '<div class="col-md-5">' +
                            '<select name="field_value[]" class="form-control">' +
                                '<option value="text">Text</option>' +
                                '<option value="date">Date</option>' +
                            '</select>' +
                        '</div>' +
                        '<div class="col-md-2">' +
                            '<a href="javascript:void(0);" class="btn btn-danger remove_field">Remove</a>' +
                        '</div>' +
                   '</div>';
        $("#dynamic_fields").append(html);
    });

    // Remove field
    $(document).on("click", ".remove_field", function(){
        $(this).closest('.dynamic_row').remove();
    });
});


</script>
