<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Assignment extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        // if (!is_admin()) {
        //     access_denied('hr');
        // }
        $this->load->model('hr/assignment_model');
        $this->load->model('hr/candidate_model');
        $this->load->model('Candidate_project_model');
    }

    public function index()
    {
        $data['title'] = _l('hr_assignments');
        $data['candidateproject'] = $this->Candidate_project_model->get_assignments_with_details();
        $this->load->view('assignments/manage', $data);
    }

    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $assignmentData = [
                'candidate_id' => (int)($post['candidate_id'] ?? 0),
                'title' => trim($post['title'] ?? ''),
                'description' => trim($post['description'] ?? ''),
                'file_path' => trim($post['file_path'] ?? ''),
                'status' => 'pending',
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/assignment/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'assignment_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $assignmentData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $assignmentData['file_path'] = '';
                }
            } else {
                $assignmentData['file_path'] = '';
            }

            $id = $this->assignment_model->add($assignmentData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_assignment')));
            }
            redirect(admin_url('hr/assignment'));
        }

        $data['title'] = _l('hr_new_assignment');
        $data['candidates'] = $this->candidate_model->all();
        $this->load->view('assignments/add_edit', $data);
    }

    public function edit($id)
{
    $this->load->model('Assignment_comment_model');
    $this->load->model('Candidate_project_model');

    // Fetch single project by ID
    $candidate_project = $this->Candidate_project_model->get($id);
    if (!$candidate_project) {
        show_404();
    }
    

    // Fetch all projects for this candidate (or all available projects)
    $candidate_projects = $this->Candidate_project_model->all();

    // Pass everything to view
    $data = [
        'title'                => _l('hr_edit_assignment'),
        'assignment_id'        => $id,
        'assignment_comments'  => $this->Assignment_comment_model->get_comments_by_assignment($id),
        'candidate_projects'   => $candidate_projects,
        'candidate_project'    => $candidate_project, // keep if needed individually
    ];

    $this->load->view('assignments/add_edit', $data);
}



    public function delete($id)
    {
        $this->assignment_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_assignment')));
        redirect(admin_url('hr/assignment'));
    }

    // public function process($id)
    // {
    //     $this->load->helper('hr_email');
    //     $this->load->model('Assignment_comment_model'); // Load the comment model

    //     if (!is_numeric($id)) {
    //         show_error('Invalid Assignment ID');
    //     }

    //     $action  = $this->input->post('status', true); // approve, reject, or comment
    //     $comment = $this->input->post('comment', true);

    //     if ($action === 'approve' || $action === 'reject') {
    //         // Determine status
    //         $status = strtolower($action) === 'approve' ? 'approved' : 'rejected';

    //         // Prepare update data
    //         $updateData = ['status' => $status];

    //         // Only save approved timestamp if approved
    //         if ($status === 'approved') {
    //             $updateData['approved_at'] = date('Y-m-d H:i:s');
    //         }

    //         // Optionally save comment in assignment table if you want
    //         if (!empty($comment)) {
    //             $updateData['comment'] = $comment;
    //         }

    //         // Update assignment
    //         $this->db->where('id', $id)->update('tblcandidate_project_assign', $updateData);

    //         if ($status === 'approved') {
    //             // Fetch assignment + candidate
    //             $this->db->select('cpa.staff_id, hc.email, hc.first_name, hc.last_name, hc.id as candidate_id, hc.email_token');
    //             $this->db->from('tblcandidate_project_assign cpa');
    //             $this->db->join('tblhr_candidates hc', 'hc.staff_id = cpa.staff_id', 'left');
    //             $this->db->where('cpa.id', $id);
    //             $assignment = $this->db->get()->row();

    //             // Insert certification
    //             if ($assignment && $assignment->candidate_id) {
    //                 $template = $this->db->select('*')->from('tblhr_certificate_template')->limit(1)->get()->row();

    //                 if ($template) {
    //                     $certificationData = [
    //                         'candidate_id'     => $assignment->candidate_id,
    //                         'certificate_type' => $template->id,
    //                         'created_at'       => date('Y-m-d H:i:s'),
    //                         'status'           => 'generated'
    //                     ];
    //                     $this->db->insert('tblhr_certifications', $certificationData);
    //                 }
    //             }

    //             // Send approval email
    //             if ($assignment && $assignment->email) {
    //                 $emailToken = $assignment->email_token ?: bin2hex(random_bytes(16));
    //                 if (empty($assignment->email_token)) {
    //                     $this->db->where('id', $assignment->candidate_id)
    //                             ->update('tblhr_candidates', ['email_token' => $emailToken]);
    //                 }

    //                 $viewLink = site_url('hr/candidate_certificate/index/' . $emailToken);
    //                 $subject  = "Your Assignment is Approved";
    //                 $body     = "<p>Hello {$assignment->first_name} {$assignment->last_name},</p>
    //                             <p>Your assignment has been approved, and your certificate is ready.</p>
    //                             <p>You can view it here:</p>
    //                             <a href='{$viewLink}'>View Certification</a>
    //                             <p>Regards,<br>HR Team</p>";

    //                 hr_send_email($assignment->email, $subject, $body);
    //             }
    //         }

    //         set_alert('success', _l('hr_assignment_' . $status));
    //     }
    //     elseif ($action === 'comment' && !empty($comment)) {
    //         // Add comment only
    //         $this->Assignment_comment_model->add_comment([
    //             'assignment_id' => $id,
    //             'staff_id'      => get_staff_user_id(),
    //             'comment'       => $comment
    //         ]);

    //         set_alert('success', _l('Assignment Comment Added'));
    //     }

    //     redirect(admin_url('hr/assignment'));
    // }

//     public function process($id)
// {
//     $this->load->helper('hr_email');
//     $this->load->model('Assignment_comment_model');
//     $this->load->model('Candidate_project_model');

//     if (!is_numeric($id)) {
//         show_error('Invalid Assignment ID');
//     }

//     $action  = $this->input->post('status', true);
//     $comment = $this->input->post('comment', true);

//     // Get the selected project
//     $project = $this->db->where('id', $id)->get('tblcandidate_project_assign')->row();
//     if (!$project) {
//         show_error('Project not found.');
//     }

//     if ($action === 'approve' || $action === 'reject') {
//         $status = strtolower($action) === 'approve' ? 'approved' : 'rejected';

//         $updateData = ['status' => $status];
//         if ($status === 'approved') {
//             $updateData['approved_at'] = date('Y-m-d H:i:s');
//         }
//         if (!empty($comment)) {
//             $updateData['comment'] = $comment;
//         }

//         // ✅ Approve all projects of the same candidate
//         $this->db->where('staff_id', $project->staff_id)
//                  ->update('tblcandidate_project_assign', $updateData);

//         // If approved, continue with certification + email
//         if ($status === 'approved') {
//             // Fetch candidate info
//             $this->db->select('hc.email, hc.first_name, hc.last_name, hc.id as candidate_id, hc.email_token');
//             $this->db->from('tblhr_candidates hc');
//             $this->db->where('hc.staff_id', $project->staff_id);
//             $assignment = $this->db->get()->row();

//             if ($assignment && $assignment->candidate_id) {
//                 // Insert certificate
//                 $template = $this->db->select('*')
//                                      ->from('tblhr_certificate_template')
//                                      ->limit(1)
//                                      ->get()
//                                      ->row();

//                 if ($template) {
//                     $certificationData = [
//                         'candidate_id'     => $assignment->candidate_id,
//                         'certificate_type' => $template->id,
//                         'created_at'       => date('Y-m-d H:i:s'),
//                         'status'           => 'generated'
//                     ];
//                     $this->db->insert('tblhr_certifications', $certificationData);
//                 }
//             }

//             // Send approval email
//             // if ($assignment && $assignment->email) {
//             //     $emailToken = $assignment->email_token ?: bin2hex(random_bytes(16));
//             //     if (empty($assignment->email_token)) {
//             //         $this->db->where('id', $assignment->candidate_id)
//             //                  ->update('tblhr_candidates', ['email_token' => $emailToken]);
//             //     }

//             //     $viewLink = site_url('hr/candidate_certificate/index/' . $emailToken);
//             //     $subject  = "Your Assignments are Approved";
//             //     $body     = "<p>Hello {$assignment->first_name} {$assignment->last_name},</p>
//             //                 <p>All your assignments have been approved, and your certificate is ready.</p>
//             //                 <p>You can view it here:</p>
//             //                 <a href='{$viewLink}'>View Certification</a>
//             //                 <p>Regards,<br>HR Team</p>";

//             //     hr_send_email($assignment->email, $subject, $body);
//             // }
//         }

//         set_alert('success', _l('All assignments for this candidate marked as ' . ucfirst($status)));
//     }
//     elseif ($action === 'comment' && !empty($comment)) {
//         // Add a single comment (optional: could loop all if you want)
//         $this->Assignment_comment_model->add_comment([
//             'assignment_id' => $id,
//             'staff_id'      => get_staff_user_id(),
//             'comment'       => $comment
//         ]);

//         set_alert('success', _l('Assignment Comment Added'));
//     }

//     redirect(admin_url('hr/assignment'));
// }

public function process($id)
{
    $this->load->helper('hr_email');
    $this->load->model('Assignment_comment_model');
    $this->load->model('Candidate_project_model');

    if (!is_numeric($id)) {
        show_error('Invalid Assignment ID');
    }

    $action = $this->input->post('status', true);

    // Always raw strings
    $rawComment  = $this->input->post('comment', true);
    $rawTags     = $this->input->post('tags', true);
    $rawAttach   = $this->input->post('attachments', true);

    // Decode comment JSON
    $commentData = json_decode($rawComment, true);

    // Fallback for malformed or missing JSON
    if (json_last_error() !== JSON_ERROR_NONE || !is_array($commentData)) {
        $commentData = [];
    }

    // Extract data safely
    $commentText = $commentData['text'] ?? $rawComment ?? '';
    $tags        = $commentData['tags'] ?? json_decode($rawTags, true) ?? [];
    $attachments = $commentData['attachments'] ?? json_decode($rawAttach, true) ?? [];

    // ✅ Debug Log (optional)
    // log_message('error', 'FINAL COMMENT DATA: ' . print_r($commentData, true));

    // Validate project
    $project = $this->db->where('id', $id)->get('tblcandidate_project_assign')->row();
    if (!$project) {
        show_error('Project not found.');
    }

    // ====== APPROVE / REJECT ======
    if (in_array($action, ['approve', 'reject'])) {
        $status = $action === 'approve' ? 'approved' : 'rejected';

        $updateData = ['status' => $status];
        if ($status === 'approved') {
            $updateData['approved_at'] = date('Y-m-d H:i:s');
        }

        if (!empty($commentText)) {
            $updateData['comment'] = json_encode([
                'text'        => $commentText,
                'tags'        => $tags,
                'attachments' => $attachments
            ], JSON_UNESCAPED_UNICODE);
        }

        $this->db->where('staff_id', $project->staff_id)
                 ->update('tblcandidate_project_assign', $updateData);

        // Auto-certificate logic...
        if ($status === 'approved') {
            $assignment = $this->db->select('hc.email, hc.first_name, hc.last_name, hc.id as candidate_id, hc.email_token')
                                   ->from('tblhr_candidates hc')
                                   ->where('hc.staff_id', $project->staff_id)
                                   ->get()
                                   ->row();

            if ($assignment && $assignment->candidate_id) {
                $template = $this->db->limit(1)->get('tblhr_certificate_template')->row();
                if ($template) {
                    $this->db->insert('tblhr_certifications', [
                        'candidate_id'     => $assignment->candidate_id,
                        'certificate_type' => $template->id,
                        'created_at'       => date('Y-m-d H:i:s'),
                        'status'           => 'generated'
                    ]);
                }
            }
        }

        set_alert('success', _l('All assignments marked as ' . ucfirst($status)));
    }

    // ====== COMMENT ONLY ======
    elseif ($action === 'comment' && !empty($commentText)) {
        $this->Assignment_comment_model->add_comment([
            'assignment_id' => $id,
            'staff_id'      => get_staff_user_id(),
            'comment'       => json_encode([
                'text'        => $commentText,
                'tags'        => $tags,
                'attachments' => $attachments
            ], JSON_UNESCAPED_UNICODE)
        ]);

        set_alert('success', _l('Assignment Comment Added'));
    }

    redirect(admin_url('hr/assignment'));
}

public function upload_comment_attachment()
{
    $uploadPath = FCPATH . 'uploads/comments/';
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0777, true);
    }

    if (!empty($_FILES['file']['name'])) {
        $config['upload_path']   = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|zip|rar';
        $config['max_size']      = 5120;
        $config['encrypt_name']  = true;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            echo json_encode(['success' => false, 'error' => strip_tags($this->upload->display_errors())]);
            return;
        }

        $data = $this->upload->data();
        echo json_encode([
            'success' => true,
            'file' => [
                'name' => $data['client_name'],
                'path' => 'uploads/comments/' . $data['file_name']
            ]
        ]);
        return;
    }

    echo json_encode(['success' => false, 'error' => 'No file uploaded']);
}



public function upload_attachment()
{
    if (!empty($_FILES['file']['name'])) {
        $uploadPath = FCPATH . 'uploads/assignment_attachments/';
        if (!is_dir($uploadPath)) mkdir($uploadPath, 0777, true);

        $fileName = time() . '_' . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $_FILES['file']['name']);
        $filePath = $uploadPath . $fileName;

        if (move_uploaded_file($_FILES['file']['tmp_name'], $filePath)) {
            echo json_encode(['success' => true, 'filename' => $fileName]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Upload failed']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'No file provided']);
    }
}







    public function download($id)
    {
        $assignment = $this->assignment_model->get($id);
        if ($assignment && $assignment->file_path) {
            $file_path = FCPATH . $assignment->file_path;
            if (file_exists($file_path)) {
                force_download($file_path, null);
            } else {
                set_alert('danger', _l('file_not_found'));
            }
        } else {
            set_alert('danger', _l('assignment_not_found'));
        }
        redirect(admin_url('hr/assignment'));
    }

    public function delete_comment($comment_id)
    {
        $this->load->model('Assignment_comment_model');

        if (!is_numeric($comment_id)) {
            show_error('Invalid Comment ID');
        }

        if ($this->Assignment_comment_model->delete_comment($comment_id)) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete comment']);
        }
    }
}
