<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_assignment extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        // if (!is_admin()) {
        //     access_denied('hr');
        // }
        $this->load->model('hr/assignment_model');
        $this->load->model('hr/candidate_model');       
         $this->load->model('Candidate_project_model');

        
    }

    public function index()
    {
        $data['title'] = _l('hr_candidate_assignments');
        // Get logged-in staff ID
        $staff_id = $this->session->userdata('staff_user_id'); 
            $this->db->select('
            c.first_name, 
            c.last_name, 
            pm.id as project_member_id, 
            p.id as project_id, 
            p.name as project_name, 
            p.start_date, 
            p.deadline as end_date
        ');
        $this->db->from('tblhr_candidates as c');
        $this->db->join('tblproject_members as pm', 'pm.staff_id = c.staff_id', 'inner');
        $this->db->join('tblprojects as p', 'p.id = pm.project_id', 'inner');
        $this->db->where('c.staff_id', $staff_id);
        $data['projects'] = $this->db->get()->result_array();
        // var_dump($data['projects']); die;
        $this->load->view('candidate_assignments/manage', $data);
    }

    // public function upload($id = null)
    // {
    //     $this->load->database();
    //     $staff_id = get_staff_user_id();

    //     // Step 1: Fetch all projects for this staff, including assignment status
    //     $this->db->select('
    //         pm.id as project_member_id,
    //         pm.staff_id,
    //         p.id as project_id,
    //         p.name as project_name,
    //         COALESCE(cpa.status, "pending") as status
    //     ');
    //     $this->db->from('tblproject_members pm');
    //     $this->db->join('tblprojects p', 'p.id = pm.project_id', 'inner');
    //     $this->db->join('tblcandidate_project_assign cpa', 'cpa.project_id = p.id AND cpa.staff_id = pm.staff_id', 'left');
    //     $this->db->where('pm.staff_id', $staff_id);
    //     $projects = $this->db->get()->result_array();

    //     if (empty($projects)) {
    //         show_error('No projects found for this staff.');
    //         return;
    //     }

    //     // Step 2: Determine active project
    //     $active_project = null;
    //     foreach ($projects as $project) {
    //         if ($project['project_member_id'] == $id) {
    //             $active_project = $project;
    //             break;
    //         }
    //     }

    //     if (!$active_project) {
    //         $active_project = $projects[0];
    //     }

    //     // Step 3: Pass to view
    //     $data['projects'] = $projects;
    //     $data['active_project'] = $active_project;
    //     $data['staff_id'] = $staff_id;
    //     $data['title'] = _l('hr_candidate_assignments');

    //     $this->load->view('candidate_assignments/upload', $data);
    // }

    public function upload($id = null)
{
    $this->load->database();
    $staff_id = get_staff_user_id();

    // Step 1: Fetch all projects for this staff, including assignment status
    $this->db->select('
        pm.id as project_member_id,
        pm.staff_id,
        p.id as project_id,
        p.name as project_name,
        COALESCE(cpa.status, "pending") as status
    ');
    $this->db->from('tblproject_members pm');
    $this->db->join('tblprojects p', 'p.id = pm.project_id', 'inner');
    $this->db->join('tblcandidate_project_assign cpa', 'cpa.project_id = p.id AND cpa.staff_id = pm.staff_id', 'left');
    $this->db->where('pm.staff_id', $staff_id);
    $projects = $this->db->get()->result_array();

    if (empty($projects)) {
        show_error('No projects found for this staff.');
        return;
    }

    // Step 2: Determine active project
    $active_project = null;
    foreach ($projects as $project) {
        if ($project['project_member_id'] == $id) {
            $active_project = $project;
            break;
        }
    }

    if (!$active_project) {
        $active_project = $projects[0];
    }

    // Step 3: Fetch comments for this staff + project, sorted by ID ASC
    $this->db->select('ac.*');
    $this->db->from('tblhr_assignment_comments ac');
    $this->db->join('tblcandidate_project_assign cpa', 'cpa.id = ac.assignment_id', 'inner');
    $this->db->where('cpa.staff_id', $staff_id);
    $this->db->where('cpa.project_id', $active_project['project_id']);
    $this->db->order_by('ac.id', 'ASC');
    $comments = $this->db->get()->result_array();

    // Step 4: Pass to view
    $data['projects'] = $projects;
    $data['active_project'] = $active_project;
    $data['comments'] = $comments; // Send comments to view
    $data['staff_id'] = $staff_id;
    $data['title'] = _l('hr_candidate_assignments');

    $this->load->view('candidate_assignments/upload', $data);
}



    public function submit_assignment()
{
    $this->load->model('Candidate_project_model');

    $project_id = $this->input->post('project_id');
    $staff_id   = $this->input->post('staff_id');

    $upload_path = './uploads/candidate_assignments/';

    // Create upload folder if it doesn't exist
    if (!is_dir($upload_path)) {
        mkdir($upload_path, 0777, true);
    }

    // Only accept these file inputs
    $files = ['source_code', 'report', 'other'];

    // Common data for DB
    $data = [
        'project_id' => $project_id,
        'staff_id'   => $staff_id,
    ];

    // Upload each file
    foreach ($files as $file) {
        if (!empty($_FILES[$file]['name'])) {

            $config = [
                'upload_path'   => $upload_path,
                'allowed_types' => 'zip',   // only ZIP files allowed
                'max_size'      => 5120,    // 5 MB in kilobytes
                'file_name'     => time() . '_' . $file . '_' . $_FILES[$file]['name'],
            ];

            $this->load->library('upload', $config);

            if ($this->upload->do_upload($file)) {
                $upload_data = $this->upload->data();
                $data[$file] = 'uploads/candidate_assignments/' . $upload_data['file_name'];
            } else {
                // Upload error
                $error = $this->upload->display_errors();
                $this->session->set_flashdata('error', $error);
                redirect(admin_url('candidate_assignments'));
                return;
            }
        }
    }

    // Save to database
    $this->Candidate_project_model->insert_assignment($data);

    $this->session->set_flashdata('success', 'Assignment uploaded successfully.');
    redirect(admin_url('hr/candidate_assignment'));
}

public function request_certificate($staff_id)
{
    $this->load->database();
    $this->load->helper('hr_email');

    // 1️⃣ Get the candidate assignment info
    $this->db->select('c.id as candidate_id, c.first_name, c.last_name, c.email, c.email_token');
    $this->db->from('tblhr_candidates as c');
    $this->db->join('tblproject_members as pm', 'pm.staff_id = c.staff_id', 'left');
    $this->db->where('c.staff_id', $staff_id);
    $assignment = $this->db->get()->row();

    if (!$assignment || empty($assignment->email)) {
        set_alert('danger', 'No valid candidate email found.');
        redirect(admin_url('hr/candidate_assignment/upload'));
        return;
    }

    // 2️⃣ Generate or reuse token
    $emailToken = $assignment->email_token ?: bin2hex(random_bytes(16));
    if (empty($assignment->email_token)) {
        $this->db->where('id', $assignment->candidate_id)
                 ->update('tblhr_candidates', ['email_token' => $emailToken]);
    }

    // 3️⃣ Build mail content
    $viewLink = site_url('hr/candidate_certificate/index/' . $emailToken);
    $subject  = "Your Assignments are Approved 🎉";
    $body     = "
        <p>Hello {$assignment->first_name} {$assignment->last_name},</p>
        <p>All your assignments have been approved, and your certificate is now ready.</p>
        <p>You can view it here:</p>
        <a href='{$viewLink}'>View Certification</a>
        <p>Warm regards,<br>HR Team</p>
    ";

    // 4️⃣ Send email
    hr_send_email($assignment->email, $subject, $body);

    // 5️⃣ Redirect with success message
    set_alert('success', 'Certificate request email sent successfully to ' . $assignment->email);
    redirect(admin_url('hr/candidate_assignment/upload'));
}





    public function delete($id)
    {
        $this->assignment_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_assignment')));
        redirect(admin_url('hr/assignment'));
    }

    public function approve($id)
    {
        $this->assignment_model->approve($id);
        set_alert('success', _l('hr_assignment_approved'));
        redirect(admin_url('hr/assignment'));
    }

    public function reject($id)
    {
        $this->assignment_model->reject($id);
        set_alert('success', _l('hr_assignment_rejected'));
        redirect(admin_url('hr/assignment'));
    }

    public function download($id)
    {
        $assignment = $this->assignment_model->get($id);
        if ($assignment && $assignment->file_path) {
            $file_path = FCPATH . $assignment->file_path;
            if (file_exists($file_path)) {
                force_download($file_path, null);
            } else {
                set_alert('danger', _l('file_not_found'));
            }
        } else {
            set_alert('danger', _l('assignment_not_found'));
        }
        redirect(admin_url('hr/assignment'));
    }
}
