<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Mpdf\Mpdf;

class Candidate_certificate extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('email'); // Perfex uses PHPMailer wrapper
        $this->load->model('candidate_model'); // Candidate data
        $this->load->model('candidate_client_model'); // Custom model for candidate actions
        $this->load->model('emails_model'); // For sending emails
        $this->load->model('Certificate_template_model'); // Model for certificates
    }

    /** Candidate login page */
    public function index($token = '')
    {
        $data['title'] = _l('Candidate Login');
        $data['candidate'] = null;

        if ($token != '') {
            $candidate = $this->candidate_model->get_by_token($token);

            if (!$candidate) {
                set_alert('danger', 'Invalid or expired verification link.');
            } else {
                $data['candidate'] = $candidate;

                // Generate OTP
                $email = $candidate->email;
                $otp = rand(100000, 999999);

                // Save OTP
                $this->candidate_client_model->save_otp($email, $otp);

                // Send OTP email
                $subject = 'Your Candidate OTP Code';
                $message = 'Your OTP is: <b>' . $otp . '</b>';
                $this->emails_model->send_simple_email($email, $subject, $message);

                set_alert('success', 'OTP has been sent to your email.');
            }
        }

        $data['token'] = $token;
        $this->data($data);
        $this->view('hr/candidate_client/index');
        $this->layout();
    }

    /** OTP Verification page */
    public function verify()
    {
        $email = $this->input->get('email');
        $data['title'] = _l('Verify OTP');
        $data['email'] = $email;

        $this->data($data);
        $this->view('hr/candidate_client/verify');
        $this->layout();
    }

    /** Check OTP */
    public function check_otp()
{
    $email = $this->input->post('email');
    $otp_array = $this->input->post('otp');

    // Safely handle OTP whether it's an array or string
    $otp = is_array($otp_array) ? implode('', $otp_array) : $otp_array;

    if ($this->candidate_client_model->verify_otp($email, $otp)) {
        $candidate = $this->candidate_client_model->get_by_email($email);
        $candidate_id = $candidate ? $candidate->id : null;

        if ($candidate_id) {
            set_alert('success', 'OTP Verified Successfully');
            redirect(site_url('hr/candidate_certificate/certificates_list/'.$candidate_id));
        } else {
            set_alert('danger', 'Candidate not found');
            redirect(site_url('candidate_certificate/verify?email=' . urlencode($email)));
        }
    } else {
        set_alert('danger', 'Invalid OTP');
        redirect(site_url('candidate_certificate/verify?email=' . urlencode($email)));
    }
}


    /** Candidate Dashboard */
    public function dashboard()
    {
        $data['title'] = _l('Candidate Dashboard');
        $this->data($data);
        $this->view('hr/candidate_client/dashboard');
        $this->layout();
    }

    /** List all certificates for candidate */
    public function certificates_list($candidate_id = null)
    {
        if (!$candidate_id) {
            $candidate_id = get_client_user_id();
        }

        $data['title'] = _l('Certificates List');
        $data['certificates'] = $this->candidate_client_model->get_candidate_certificates($candidate_id);

        $this->data($data);
        $this->view('hr/candidate_client/certificates_list');
        $this->layout();
    }

    

    /** View certificate PDF */
//     public function view_certificate_pdf($certificate_id)
// {
//     $certificate = $this->candidate_client_model->get_certificate_by_id($certificate_id);

//     if (!$certificate) {
//         show_error('Certificate not found');
//     }

//     $this->load->helper('pdf');
//     $this->load->library('pdf');

//     // Create custom PDF (landscape for certificates)
//     $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
//     $pdf->SetTitle($certificate->template_title);
//     $pdf->SetAuthor(get_option('companyname'));
//     $pdf->SetMargins(0, 0, 0); // no margins for full-page background
//     $pdf->SetAutoPageBreak(false, 0); // disable auto page breaks

//     // Add new page
//     $pdf->AddPage();

//     // 🔹 Set Background Image (centered)
//     if (!empty($certificate->template_background)) {
//         $backgroundPath = FCPATH . ltrim($certificate->template_background, '/');

//         if (file_exists($backgroundPath)) {
//             $pageWidth  = $pdf->GetPageWidth();
//             $pageHeight = $pdf->GetPageHeight();

//             list($imgWidth, $imgHeight) = getimagesize($backgroundPath);
//             $imgWidthMM  = ($imgWidth / 96) * 25.4;
//             $imgHeightMM = ($imgHeight / 96) * 25.4;

//             $x = ($pageWidth - $imgWidthMM) / 2;
//             $y = ($pageHeight - $imgHeightMM) / 2;

//             $pdf->Image($backgroundPath, $x, $y, $imgWidthMM, $imgHeightMM, '', '', '', true, 300, '', false, false, 0);
//         } else {
//             log_message('error', 'Certificate background not found: ' . $backgroundPath);
//         }
//     }

//     // 🔹 Overlay Certificate Content
//     $pdf->SetFont('helvetica', '', 18);
//     $pdf->SetTextColor(40, 40, 40);

//     $html = '
//         <div style="text-align:center; padding-top:100px;">
//             <h1 style="font-size:30px; margin-bottom:0;">' . $certificate->template_title . '</h1>
//             <h2 style="font-size:26px; margin:10px 0; font-weight:bold;">' . $certificate->candidate_name . '</h2>
//             <br><br>
//             <div style="font-size:14px;">' . nl2br($certificate->template_details) . '</div>
//         </div>
//     ';

//     $pdf->writeHTML($html, true, false, true, false, '');

//     // Output the PDF
//     $pdf->Output(slug_it($certificate->template_title) . '.pdf', 'I');
// }


    // public function view_certificate_pdf($certificate_id)
    // {
    //     // 🔹 Load required model, helper, and library
    //     $this->load->model('candidate_client_model');
    //     $this->load->helper('pdf');
    //     $this->load->library('pdf');

    //     // 🔹 Get certificate record
    //     $certificate = $this->candidate_client_model->get_certificate_by_id($certificate_id);
    //     if (!$certificate) {
    //         show_error('Certificate not found');
    //     }

    //     // 🔹 Get candidate info based on candidate_id
    //     $candidate = $this->db->where('id', $certificate->candidate_id)
    //                         ->get('tblhr_candidates')
    //                         ->row();
                        
    //     $template = $this->db->where('id', $certificate->certificate_type)
    //                      ->get('tblhr_certificate_template')
    //                      ->row();
                        
    //     $project = $this->db->where('staff_id', $certificate->staff_id)
    //                     ->where('status', 'approved')
    //                     ->order_by('approved_at', 'DESC')
    //                     ->get('tblcandidate_project_assign')
    //                     ->row();

    //     // Safety check
    //     if ($candidate) {
    //         $certificate->first_name = $candidate->first_name;
    //         $certificate->last_name  = $candidate->last_name;
    //     } else {
    //         $certificate->first_name = '';
    //         $certificate->last_name  = '';
    //     }
    //     $template->title = '';

    //     // 🔹 Inline helper for tag replacement
    //     $parse_certificate_tags = function ($template_details, $certificate) {
    //         $tags = [
    //             '$firstname'       => isset($certificate->first_name) ? $certificate->first_name : '',
    //             '$lastname'        => isset($certificate->last_name) ? $certificate->last_name : '',
    //             '$projecttitle'    => isset($certificate->title) ? $certificate->title : '',
    //             '$duration'        => isset($certificate->date) ? _d($certificate->date) : date('d-m-Y'),
    //         ];
    //         return strtr($template_details, $tags);
    //     };

    //     // 🔹 Initialize TCPDF
    //     $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
    //     $pdf->SetTitle($certificate->template_title);
    //     $pdf->SetAuthor(get_option('companyname'));
    //     $pdf->SetMargins(0, 0, 0);
    //     $pdf->SetAutoPageBreak(false, 0);
    //     $pdf->AddPage();

    //     // 🔹 Background image if exists
    //     if (!empty($certificate->template_background)) {
    //         $backgroundPath = FCPATH . ltrim($certificate->template_background, '/');
    //         if (file_exists($backgroundPath)) {
    //             $pageWidth  = $pdf->GetPageWidth();
    //             $pageHeight = $pdf->GetPageHeight();
    //             list($imgWidth, $imgHeight) = getimagesize($backgroundPath);
    //             $imgWidthMM  = ($imgWidth / 96) * 25.4;
    //             $imgHeightMM = ($imgHeight / 96) * 25.4;
    //             $x = ($pageWidth - $imgWidthMM) / 2;
    //             $y = ($pageHeight - $imgHeightMM) / 2;
    //             $pdf->Image($backgroundPath, $x, $y, $imgWidthMM, $imgHeightMM, '', '', '', true, 300, '', false, false, 0);
    //         }
    //     }

    //     // 🔹 Set text styles
    //     $pdf->SetFont('helvetica', '', 18);
    //     $pdf->SetTextColor(40, 40, 40);

    //     // 🔹 Replace placeholders like {first_name}, {lastname}, etc.
    //     $template_details = $parse_certificate_tags($certificate->template_details, $certificate);

    //     $html = '
    //         <div style="text-align:center; padding-top:100px;">
    //             <h1 style="font-size:30px; margin-bottom:0;">' . $certificate->template_title . '</h1>
    //             <h2 style="font-size:26px; margin:10px 0; font-weight:bold;">' . $certificate->candidate_name . '</h2>
    //             <br><br>
    //             <div style="font-size:14px;">' . nl2br($template_details) . '</div>
    //         </div>
    //     ';

    //     $pdf->writeHTML($html, true, false, true, false, '');
    //     $pdf->Output(slug_it($certificate->template_title) . '.pdf', 'I');
    // }

public function view_certificate_pdf($certificate_id)
{
    // 🔹 Load required model, helper, and library
    $this->load->model('candidate_client_model');
    $this->load->helper('pdf');
    $this->load->library('pdf');

    // 🔹 Get certificate record
    $certificate = $this->candidate_client_model->get_certificate_by_id($certificate_id);
    if (!$certificate) {
        show_error('Certificate not found');
    }

    // ------------------------------------------------------------------
    // Resolve staff_id (certificate → candidate → staff)
    // ------------------------------------------------------------------
    $staff_id = null;
    $candidate = null;

    if (isset($certificate->staff_id) && !empty($certificate->staff_id)) {
        $staff_id = $certificate->staff_id;
    } elseif (isset($certificate->candidate_id) && !empty($certificate->candidate_id)) {
        $candidate_row = $this->db->where('id', $certificate->candidate_id)
                                  ->get('tblhr_candidates')
                                  ->row();
        if ($candidate_row && isset($candidate_row->staff_id)) {
            $staff_id = $candidate_row->staff_id;
        }
    }

    // ------------------------------------------------------------------
    // Fetch candidate and project data
    // ------------------------------------------------------------------
    if ($staff_id) {
        $candidate = $this->db->where('staff_id', $staff_id)
                              ->get('tblhr_candidates')
                              ->row();

        $project = $this->db->where('staff_id', $staff_id)
                            ->where('status', 'approved')
                            ->order_by('approved_at', 'DESC')
                            ->get('tblcandidate_project_assign')
                            ->row();
    } else {
        $candidate = null;
        $project   = null;
    }

    // ------------------------------------------------------------------
    // Fetch certificate template
    // ------------------------------------------------------------------
    $template = $this->db->where('id', $certificate->certificate_type)
                         ->get('tblhr_certificate_template')
                         ->row();

    // ------------------------------------------------------------------
    // Merge data
    // ------------------------------------------------------------------
    $certificate->first_name = $candidate->first_name ?? '';
    $certificate->last_name  = $candidate->last_name ?? '';
    $certificate->candidate_name = trim(($candidate->first_name ?? '') . ' ' . ($candidate->last_name ?? ''));
    $certificate->title = $project->project_title ?? '';

    // 🔹 Duration = difference between candidate.created_at and project.approved_at
    $start_date = $candidate->created_at ?? null;
    $end_date   = $project->approved_at ?? null;

    if ($start_date && $end_date) {
        $certificate->duration = _d($start_date) . ' - ' . _d($end_date);

        // Optional: also show human-readable duration (like “1 month 5 days”)
        $start = new DateTime($start_date);
        $end   = new DateTime($end_date);
        $diff  = $start->diff($end);
        $certificate->duration_text = trim(
            ($diff->y ? $diff->y . ' year' . ($diff->y > 1 ? 's ' : ' ') : '') .
            ($diff->m ? $diff->m . ' month' . ($diff->m > 1 ? 's ' : ' ') : '') .
            ($diff->d ? $diff->d . ' day' . ($diff->d > 1 ? 's' : '') : '')
        );
    } else {
        $certificate->duration = '';
        $certificate->duration_text = '';
    }

    // ------------------------------------------------------------------
    // Inline tag parser
    // ------------------------------------------------------------------
    $parse_certificate_tags = function ($template_details, $certificate) {
        $tags = [
            '$firstname'    => $certificate->first_name ?? '',
            '$lastname'     => $certificate->last_name ?? '',
            '$projecttitle' => $certificate->title ?? '',
            '$duration'     => $certificate->duration ?? '',
            '$duration' => $certificate->duration_text ?? '',
        ];
        return strtr($template_details, $tags);
    };

    // ------------------------------------------------------------------
    // Initialize TCPDF
    // ------------------------------------------------------------------
    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($template->title ?? 'Certificate');
    $pdf->SetAuthor(get_option('companyname'));
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetAutoPageBreak(false, 0);
    $pdf->AddPage();

    // ------------------------------------------------------------------
    // Background image (if exists)
    // ------------------------------------------------------------------
    if (!empty($template->background_image)) {
        $backgroundPath = FCPATH . ltrim($template->background_image, '/');
        if (file_exists($backgroundPath)) {
            $pageWidth  = $pdf->GetPageWidth();
            $pageHeight = $pdf->GetPageHeight();
            list($imgWidth, $imgHeight) = getimagesize($backgroundPath);
            $imgWidthMM  = ($imgWidth / 96) * 25.4;
            $imgHeightMM = ($imgHeight / 96) * 25.4;
            $x = ($pageWidth - $imgWidthMM) / 2;
            $y = ($pageHeight - $imgHeightMM) / 2;
            $pdf->Image($backgroundPath, $x, $y, $imgWidthMM, $imgHeightMM, '', '', '', true, 300, '', false, false, 0);
        }
    }

    // ------------------------------------------------------------------
    // Render HTML
    // ------------------------------------------------------------------
    $pdf->SetFont('helvetica', '', 18);
    $pdf->SetTextColor(40, 40, 40);

    $template_details = $parse_certificate_tags($template->details ?? '', $certificate);

    $html = '
        <div style="text-align:center; padding-top:100px;">
            <h1 style="font-size:30px; margin-bottom:0;">' . ($template->title ?? '') . '</h1>
            <h2 style="font-size:26px; margin:10px 0; font-weight:bold;">' . $certificate->candidate_name . '</h2>
            <br><br>
            <div style="font-size:14px;">' . nl2br($template_details) . '</div>
        </div>
    ';

    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Output(slug_it($template->title ?? 'certificate') . '.pdf', 'I');
}




    public function sign_certificate($certificate_id = null)
    {
        if (!$certificate_id) {
            set_alert('danger', 'Invalid Contract');
            redirect(site_url('hr/candidate_client/certificates_list'));
        }

        $this->load->model('candidate_client_model');
        // $this->candidate_client_model->update_candidate_status($contract_id, 'open');

        $contract = $this->candidate_client_model->get_certificate_by_id($certificate_id);

        if (!$contract) {
            set_alert('danger', 'Contract not found');
            redirect(site_url('hr/candidate_certificate/certificates_list'));
        }

        $data['title'] = _l('Sign Certificate');
        $data['contract'] = $contract;

        // URL to render HTML/PDF in iframe
        $data['pdf_url'] = site_url('hr/candidate_certificate/view_certificate_pdf/' . $certificate_id);

        $this->data($data);
        $this->view('hr/candidate_client/sign_certificate');
        $this->layout();
    }

    /** Send certificate email */
    private function send_certificate_email($certificate, $pdf_path)
    {
        $this->load->helper('hr_email');

        $to = $certificate->email;
        $subject = 'Your Certificate - ' . $certificate->title;

        $body = '<p>Dear ' . $certificate->candidate_name . ',</p>';
        $body .= '<p>Congratulations! Please find attached your certificate.</p>';
        $body .= '<p>Best regards,<br>HR Team</p>';

        return hr_send_email($to, $subject, $body, $pdf_path);
    }
}
