<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Mpdf\Mpdf;
class Candidate_client extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('email'); // Perfex uses PHPMailer wrapper
        $this->load->model('candidate_model'); // ← load your model
        $this->load->model('candidate_client_model'); // Custom model
        $this->load->model('emails_model'); // for sending emails
        $this->load->model('contracts_model'); // ← load your model

    }

    public function index($token = '')
    {
        $data['title'] = _l('Candidate Login');
        $data['candidate'] = null;

        if ($token != '') {
            // Fetch candidate using token
            $candidate = $this->candidate_model->get_by_token($token);

            if (!$candidate) {
                set_alert('danger', 'Invalid or expired verification link.');
            } else {
                $data['candidate'] = $candidate;

                // Generate OTP
                $email = $candidate->email;
                $otp = rand(100000, 999999);

                // Save OTP to DB
                $this->candidate_client_model->save_otp($email, $otp);

                // Send OTP via email
                $subject = 'Your Candidate OTP Code';
                $message = 'Your OTP is: <b>' . $otp . '</b>';
                $this->emails_model->send_simple_email($email, $subject, $message);

                set_alert('success', 'OTP has been sent to your email.');
            }
        }

        // Keep the token in data to pass it to view
        $data['token'] = $token;

        // Render the index page
        $this->data($data);
        $this->view('hr/candidate_client/index');
        $this->layout();
    }

    // public function index($token = '')
    // {
    //     $data['title'] = _l('Candidate Login');
    //     $data['candidate'] = null;

    //     if ($token != '') {
    //         // Fetch candidate using token
    //         $candidate = $this->candidate_model->get_by_token($token);

    //         if (!$candidate) {
    //             set_alert('danger', 'Invalid or expired verification link.');
    //         } else {
    //             $data['candidate'] = $candidate;

    //             // Generate OTP
    //             $email = $candidate->email;
    //             $otp = rand(100000, 999999);

    //             // Save OTP to DB
    //             $this->candidate_client_model->save_otp($email, $otp);

    //             // Send OTP via email
    //             $subject = 'Your Candidate OTP Code';
    //             $message = 'Your OTP is: <b>' . $otp . '</b>';
    //             $this->emails_model->send_simple_email($email, $subject, $message);

    //             // ✅ Count how many OTPs have been sent so far (based on candidate_id)
    //             $this->db->where('candidate_id', $candidate->id);
    //             $contract = $this->db->get('tblhr_candidate_contracts')->row();

    //             if ($contract) {
    //                 // If record exists, increment the view_contract counter
    //                 $new_count = (int)$contract->view_contract + 1;
    //                 $this->db->where('candidate_id', $candidate->id);
    //                 $this->db->update('tblhr_candidate_contracts', ['view_contract' => $new_count]);
    //             } else {
    //                 // If no record exists, create a new one
    //                 $this->db->insert('tblhr_candidate_contracts', [
    //                     'candidate_id' => $candidate->id,
    //                     'view_contract' => 1,
    //                 ]);
    //             }

    //             set_alert('success', 'OTP has been sent to your email.');
    //         }
    //     }

    //     // Keep the token in data to pass it to view
    //     $data['token'] = $token;

    //     // Render the index page
    //     $this->data($data);
    //     $this->view('hr/candidate_client/index');
    //     $this->layout();
    // }



    // Step 2: Verify OTP
    public function verify()
    {
        $email = $this->input->get('email');
        $data['title'] = _l('Verify OTP');
        $data['email'] = $email;

        $this->data($data);
        $this->view('hr/candidate_client/verify');
        $this->layout();
    }

    // public function check_otp()
    // {
    //     $email = $this->input->post('email');
    //     $otp_array = $this->input->post('otp'); 
    //     $otp = implode('', $otp_array);         

    //     if ($this->candidate_client_model->verify_otp($email, $otp)) {
    //         // fetch candidate ID using email
    //         $candidate = $this->candidate_client_model->get_by_email($email); // create this if needed
    //         $candidate_id = $candidate ? $candidate->id : null;

    //         if ($candidate_id) {
    //             set_alert('success', 'OTP Verified Successfully');
    //             redirect(site_url('hr/candidate_client/contracts_list/'.$candidate_id));
    //         } else {
    //             set_alert('danger', 'Candidate not found');
    //             redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
    //         }
    //     } else {
    //         set_alert('danger', 'Invalid OTP');
    //         redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
    //     }
    // }

    public function check_otp()
{
    $email = $this->input->post('email');
    $otp_array = $this->input->post('otp'); 
    $otp = implode('', $otp_array);         

    // Verify OTP
    if ($this->candidate_client_model->verify_otp($email, $otp)) {

        // ✅ Fetch candidate using email
        $candidate = $this->candidate_client_model->get_by_email($email); // must return id, email, etc.
        $candidate_id = $candidate ? $candidate->id : null;

        if ($candidate_id) {
            // ✅ Increment or insert OTP count in tblhr_candidate_contracts
            $this->db->where('candidate_id', $candidate_id);
            $contract = $this->db->get('tblhr_candidate_contracts')->row();

            if ($contract) {
                // If record exists, increment the counter
                $new_count = (int)$contract->view_contract + 1;
                $this->db->where('candidate_id', $candidate_id);
                $this->db->update('tblhr_candidate_contracts', ['view_contract' => $new_count]);
            } else {
                // If no record exists, create a new one
                $this->db->insert('tblhr_candidate_contracts', [
                    'candidate_id' => $candidate_id,
                    'view_contract' => 1,
                ]);
            }

            // ✅ Redirect after verification
            set_alert('success', 'OTP Verified Successfully');
            redirect(site_url('hr/candidate_client/contracts_list/' . $candidate_id));
        } else {
            set_alert('danger', 'Candidate not found');
            redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
        }

    } else {
        // ✅ Optional: even for invalid OTP, you can also increment count if you wish
        $candidate = $this->candidate_client_model->get_by_email($email);
        if ($candidate && isset($candidate->id)) {
            $this->db->where('candidate_id', $candidate->id);
            $contract = $this->db->get('tblhr_candidate_contracts')->row();

            if ($contract) {
                $new_count = (int)$contract->view_contract + 1;
                $this->db->where('candidate_id', $candidate->id);
                $this->db->update('tblhr_candidate_contracts', ['view_contract' => $new_count]);
            } else {
                $this->db->insert('tblhr_candidate_contracts', [
                    'candidate_id' => $candidate->id,
                    'view_contract' => 1,
                ]);
            }
        }

        set_alert('danger', 'Invalid OTP');
        redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
    }
}



    // Candidate Dashboard
    public function dashboard()
    {
        $data['title'] = _l('Candidate Dashboard');
        $this->data($data);
        $this->view('hr/candidate_client/dashboard');
        $this->layout();
    }

    public function contracts_list($candidate_id = null)
    {

        if (!$candidate_id) {
            // Example: pull from logged-in candidate session/token
            $candidate_id = get_client_user_id(); 
            // or however you’re tracking candidates
        }

        $data['title'] = _l('Contracts List');
        $data['contracts'] = $this->candidate_client_model->get_candidate_contracts($candidate_id);
        // var_dump($data['contracts']); die;

        $this->data($data);
        $this->view('hr/candidate_client/contracts_list');
        $this->layout();
    }
    public function view_contract_pdf($contract_id)
    {
        $this->load->helper('pdf');
        $this->load->library('pdf');

        // Fetch contract + candidate + candidate contract data
        $this->db->select('
            cc.*, 
            c.title, 
            c.details, 
            c.cover_image, 
            c.background_image, 
            c.last_image, 
            c.fields_list, 
            c.company_info,
            cc.signature,
            ca.first_name, 
            ca.last_name, 
            ca.email, 
            ca.phone, 
            ca.address, 
            ca.preferred_job_type,
        ');
        $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
        $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');
        $this->db->where('cc.id', $contract_id);
        $contract = $this->db->get()->row();
        // dd($contract);

        if (!$contract) {
            show_error('Contract not found');
        }

        // Decode intern info JSON
        $intern_info = !empty($contract->intern_info) ? json_decode($contract->intern_info, true) : [];

        // Prepare dynamic fields
        $dynamic_fields = array_merge(
            [
                'intern_name' => $contract->first_name . ' ' . $contract->last_name,
                'job_role' => !empty($contract->preferred_job_type) ? ucwords($contract->preferred_job_type) : '________________',
                'email'       => $contract->email ?? '________________',
                'phone'       => $contract->phone ?? '________________',
                'address'     => $contract->address ?? '________________',
                'date'        => !empty($contract->date) ? date('d-m-Y', strtotime($contract->date)) :  '________________',
                'signature'   => '________________',

            ],
            $intern_info
        );

        // Replace placeholders in contract details
        $html_content = $contract->details;
        foreach ($dynamic_fields as $key => $value) {
            $html_content = str_replace('{' . $key . '}', $value, $html_content);
        }

        // Initialize PDF
        $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetTitle('Contract - ' . $contract->title);
        $pdf->SetAuthor(get_option('companyname'));
        $pdf->SetMargins(15, 20, 15);

        // 1️⃣ Cover Page
        if (!empty($contract->cover_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image)) {
            $pdf->AddPage();
            $pdf->Image(
                FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image,
                0, 0, 210, 297, '', '', '', true, 300
            );
        }

        // 2️⃣ Main Contract Page
        $pdf->AddPage();

        // Background image if exists
        if (!empty($contract->background_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->background_image)) {
            $pdf->Image(
                FCPATH . 'uploads/hr/contract_template/' . $contract->background_image,
                0, 0, 210, 297, '', '', '', true, 300
            );
        }

        // Build main HTML
        $html  = '<h2 style="text-align:center;">' . strtoupper($contract->title) . '</h2>';
        $html .= '<div>' . $html_content . '</div>';

        // Intern + Company details table
        $html .= '<table border="0" cellpadding="5" cellspacing="0" width="100%">
            <tr>
                <td width="50%" valign="top">
                    <strong>INTERN</strong><br><br>
                    <table cellpadding="3" cellspacing="0" border="0">';
        
        foreach (['intern_name','job_role','date','signature'] as $key) {
            $label = ucwords(str_replace('_',' ',$key));
            $value = $dynamic_fields[$key] ?? '________________';
            $html .= "<tr><td>{$label}:</td><td>{$value}</td></tr>";
        }

        $html .= '</table></td>
                <td width="50%" valign="top">
                    <strong>COMPANY DETAILS</strong>' . nl2br($contract->company_info ?: '________________') . '
                </td>
            </tr>
        </table><br /><hr width="100%" />';

        $pdf->writeHTML($html, true, false, true, false, '');

        // 3️⃣ Last Page
        if (!empty($contract->last_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->last_image)) {
            $pdf->AddPage();
            $pdf->Image(
                FCPATH . 'uploads/hr/contract_template/' . $contract->last_image,
                0, 0, 210, 297, '', '', '', true, 300
            );
        }

        // Output PDF inline
        $pdf->Output(slug_it($contract->title) . '.pdf', 'I');
    }

    public function sign_contract($contract_id = null)
    {
        if (!$contract_id) {
            set_alert('danger', 'Invalid Contract');
            redirect(site_url('hr/candidate_client/contracts_list'));
        }

        $this->load->model('candidate_client_model');
        $this->candidate_client_model->update_candidate_status($contract_id, 'open');

        $contract = $this->candidate_client_model->get_contract_by_id($contract_id);

        if (!$contract) {
            set_alert('danger', 'Contract not found');
            redirect(site_url('hr/candidate_client/contracts_list'));
        }

        $data['title'] = _l('Sign Contract');
        $data['contract'] = $contract;

        // URL to render HTML/PDF in iframe
        $data['pdf_url'] = site_url('hr/candidate_client/view_contract_pdf/' . $contract_id);

        $this->data($data);
        $this->view('hr/candidate_client/sign_contract');
        $this->layout();
    }

    public function thank_you($contract_id = null) {
        $data['title'] = _l('Thank You');
        $contract = $this->candidate_client_model->get_candidate_by_contract_by_id($contract_id);
        $data['email'] = $contract ? $contract->email : '';
        $this->data($data);
        $this->view('hr/candidate_client/thank_you');
        $this->layout();
    }

    public function view_contract($filename = '')
    {
        $path = FCPATH . 'uploads/contracts/' . $filename;

        if (file_exists($path)) {
            header('Content-Type: application/pdf');
            header('Content-Disposition: inline; filename="' . $filename . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            exit;
        } else {
            show_404();
        }
    }

    public function save_signature()
    {
        $contract_id = $this->input->post('contract_id');

        if (!$contract_id) {
            echo json_encode([
                'success'  => false,
                'error'    => 'Invalid contract ID',
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
            return;
        }

        // Common path for signature images
        $upload_dir = FCPATH . 'uploads/hr/contract_signatures/';
        $upload_url = 'uploads/hr/contract_signatures/';

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        $signature_file_path = '';
        if ($this->input->post('type') == 'draw') {
            $dataURL = $_POST['signature'];

            // Detect and remove base64 prefix dynamically
            if (strpos($dataURL, 'base64,') !== false) {
                $dataURL = explode('base64,', $dataURL)[1];
            }

            // Fix spaces
            $dataURL = str_replace(' ', '+', $dataURL);

            // Decode the base64 string
            $image_data = base64_decode($dataURL);

            if ($image_data === false) {
                return false; // Invalid base64
            }

            $file_name = 'signature_' . $contract_id . '_' . time() . '.png';
            $signature_file_path = $upload_dir . $file_name;
            file_put_contents($signature_file_path, $image_data);
            $signature_file_path = $upload_url . $file_name;
        }elseif ($this->input->post('type') == 'type') {
            $text = $this->input->post('signature');

            $im = imagecreatetruecolor(500, 150);
            $bg = imagecolorallocate($im, 255, 255, 255);
            $color = imagecolorallocate($im, 0, 0, 0);
            imagefilledrectangle($im, 0, 0, 500, 150, $bg);

            $font = FCPATH . 'application/fonts/DancingScript-Regular.ttf'; // make sure font exists
            if (file_exists($font)) {
                imagettftext($im, 32, 0, 20, 100, $color, $font, $text);
            } else {
                imagestring($im, 5, 20, 50, $text, $color);
            }

            $file_name = 'signature_' . $contract_id . '_' . time() . '.png';
            $signature_file_path = $upload_dir . $file_name;
            imagepng($im, $signature_file_path);
            imagedestroy($im);

            $signature_file_path = $upload_url . $file_name;
        }elseif (!empty($_FILES['signatureFile']['name'])) {
            $config['upload_path']   = $upload_dir;
            $config['allowed_types'] = 'jpg|jpeg|png';
            $config['file_name']     = 'signature_' . $contract_id . '_' . time();

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('signatureFile')) {
                $uploadData = $this->upload->data();
                $signature_file_path = $upload_url . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'success'  => false,
                    'error'    => $this->upload->display_errors(),
                    'csrfHash' => $this->security->get_csrf_hash()
                ]);
                return;
            }
        } else {
            echo json_encode([
                'success'  => false,
                'error'    => 'No signature provided',
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
            return;
        }

        // Save file path in DB
        $this->db->where('id', $contract_id);
        $updated = $this->db->update('tblhr_candidate_contracts', ['signature' => $signature_file_path]);

        if ($updated) {
            $this->load->model('candidate_client_model');
            $contract = $this->candidate_client_model->update_candidate_status($contract_id, 'processing');
            
            // Generate PDF with signature and send email
            $this->generate_signed_contract_pdf($contract_id, $signature_file_path);
            
            echo json_encode([
                'success'  => true,
                'signature'=> base_url($signature_file_path),
                'csrfHash' => $this->security->get_csrf_hash(),
                'contract_id' => $contract_id
            ]);
        } else {
            $error = $this->db->error();
            echo json_encode([
                'success'  => false,
                'error'    => $error['message'],
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
        }
    }

    // private function generate_signed_contract_pdf($contract_id, $signature_file_path)
    // {
    //     // Get contract details with template images
    //     $this->db->select('cc.*, c.title, c.details, c.cover_image, c.background_image, c.last_image, c.fields_list, ca.first_name, ca.last_name, ca.email, ca.phone, ca.address, cc.company_info');
    //     $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
    //     $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
    //     $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');
    //     $this->db->where('cc.id', $contract_id);
    //     $contract = $this->db->get()->row();
        
    //     if (!$contract) {
    //         return false;
    //     }

    //     // Load Perfex TCPDF helper
    //     $this->load->helper('pdf');
    //     $this->load->library('pdf');

    //     // Create new PDF instance
    //     $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        
    //     // Set document information
    //     $pdf->SetCreator('Perfex CRM HR Module');
    //     $pdf->SetAuthor('Perfex CRM');
    //     $pdf->SetTitle($contract->title);
    //     $pdf->SetSubject('Signed Contract');
        
    //     // Set margins
    //     $pdf->SetMargins(15, 15, 15);
    //     $pdf->SetHeaderMargin(5);
    //     $pdf->SetFooterMargin(10);
        
    //     // Add first page with cover image
    //     $pdf->AddPage();
        
    //     // Add cover image if exists
    //     if (!empty($contract->cover_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image)) {
    //         $cover_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image;
    //         $pdf->Image($cover_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }
        
    //     // Add second page for contract content
    //     $pdf->AddPage();
        
    //     // Add background image for content pages if exists
    //     if (!empty($contract->background_page) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->background_page)) {
    //         $background_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->background_page;
    //         $pdf->Image($background_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }
        
    //     // Set font
    //     $pdf->SetFont('helvetica', '', 12);
        
    //     // Contract content
    //     $html = '<h2 style="text-align: center; color: #333;">' . $contract->title . '</h2>';
    //     $html .= '<br><br>';
        
    //     // Candidate information
    //     $html .= '<table cellpadding="5" cellspacing="0" style="width: 100%; border: 1px solid #ddd;">';
    //     $html .= '<tr><td width="50%" valign="top"><strong>CANDIDATE DETAILS</strong><br><br>';
    //     $html .= '<strong>Name:</strong> ' . $contract->first_name . ' ' . $contract->last_name . '<br>';
    //     $html .= '<strong>Email:</strong> ' . $contract->email . '<br>';
    //     $html .= '<strong>Phone:</strong> ' . $contract->phone . '<br>';
    //     $html .= '<strong>Address:</strong> ' . $contract->address . '<br>';
    //     $html .= '</td>';
        
    //     // Company information
    //     $html .= '<td width="50%" valign="top"><strong>COMPANY DETAILS</strong><br><br>';
    //     $company_info = !empty($contract->company_info) ? $contract->company_info : 'Company information not provided';
    //     $html .= nl2br($company_info);
    //     $html .= '</td></tr></table>';
        
    //     $html .= '<br><br>';
        
    //     // Contract terms/content
    //     if (!empty($contract->details)) {
    //         $html .= '<h3>Contract Terms</h3>';
    //         $html .= '<div style="border: 1px solid #ddd; padding: 15px; background-color: rgba(249, 249, 249, 0.8);">';
    //         $html .= $contract->details;
    //         $html .= '</div>';
    //     }
        
    //     $html .= '<br><br>';
        
    //     // Signature section
    //     $html .= '<table cellpadding="10" cellspacing="0" style="width: 100%; margin-top: 50px;">';
    //     $html .= '<tr>';
    //     $html .= '<td width="50%" style="text-align: center;">';
    //     $html .= '<strong>Candidate Signature</strong><br><br>';
        
    //     // Add signature image if exists
    //     if (!empty($signature_file_path) && file_exists(FCPATH . $signature_file_path)) {
    //         $html .= '<img src="' . FCPATH . $signature_file_path . '" style="max-width: 200px; max-height: 100px; border: 1px solid #ddd;" />';
    //     } else {
    //         $html .= '<div style="border: 1px solid #ddd; height: 100px; width: 200px; margin: 0 auto; background-color: #f9f9f9;"></div>';
    //     }
        
    //     $html .= '<br><br>';
    //     $html .= '<div style="border-top: 1px solid #333; width: 200px; margin: 0 auto;"></div>';
    //     $html .= '<small>Signature</small>';
    //     $html .= '</td>';
        
    //     $html .= '<td width="50%" style="text-align: center;">';
    //     $html .= '<strong>Date</strong><br><br>';
    //     $html .= '<div style="border: 1px solid #ddd; height: 100px; width: 200px; margin: 0 auto; background-color: #f9f9f9; display: flex; align-items: center; justify-content: center;">';
    //     $html .= date('F j, Y');
    //     $html .= '</div>';
    //     $html .= '<br><br>';
    //     $html .= '<div style="border-top: 1px solid #333; width: 200px; margin: 0 auto;"></div>';
    //     $html .= '<small>Date</small>';
    //     $html .= '</td>';
    //     $html .= '</tr>';
    //     $html .= '</table>';
        
    //     // Write HTML content
    //     $pdf->writeHTML($html, true, false, true, false, '');
        
    //     // Add last page with last page image if exists
    //     if (!empty($contract->last_page) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->last_page)) {
    //         $pdf->AddPage();
    //         $last_page_image_path = FCPATH . 'uploads/hr/contract_template/' . $contract->last_page;
    //         $pdf->Image($last_page_image_path, 0, 0, 210, 297, '', '', '', true, 300, '', false, false, 0, false, false, false);
    //     }
        
    //     // Generate PDF filename
    //     $pdf_filename = 'signed_contract_' . $contract_id . '_' . time() . '.pdf';
    //     $pdf_path = FCPATH . 'uploads/hr/signed_contracts/' . $pdf_filename;
        
    //     // Ensure directory exists
    //     $pdf_dir = dirname($pdf_path);
    //     if (!is_dir($pdf_dir)) {
    //         mkdir($pdf_dir, 0755, true);
    //     }
        
    //     // Save PDF
    //     $pdf->Output($pdf_path, 'F');
        
    //     // Send email with PDF attachment
    //     $this->send_signed_contract_email($contract, $pdf_path, $pdf_filename);
        
    //     return true;
    // }
   
    
    private function generate_signed_contract_pdf($contract_id, $signature_file_path)
    {
        // Get contract details with template images (from tblhr_contracts)
        $this->db->select('
            cc.*, 
            c.title, 
            c.details, 
            c.cover_image, 
            c.background_image, 
            c.last_image, 
            c.fields_list, 
            c.company_info,
            ca.first_name, 
            ca.last_name, 
            ca.email, 
            ca.phone, 
            ca.address,
        ');
        $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
        $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');
        $this->db->where('cc.id', $contract_id);
        $contract = $this->db->get()->row();

        if (!$contract) {
            return false;
        }

        // Load Perfex PDF dependencies
        $this->load->helper('pdf');
        $this->load->library('pdf');

        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetCreator('Perfex CRM HR Module');
        $pdf->SetAuthor('Perfex CRM');
        $pdf->SetTitle($contract->title);
        $pdf->SetSubject('Signed Contract');
        $pdf->SetMargins(15, 15, 15);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(10);

        // 🟩 Cover Page
        if (!empty($contract->cover_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image)) {
            $pdf->AddPage();
            $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->cover_image, 0, 0, 210, 297, '', '', '', true, 300);
        }

        // 🟦 Content Page
        $pdf->AddPage();

        if (!empty($contract->background_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->background_image)) {
            $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->background_image, 0, 0, 210, 297, '', '', '', true, 300);
        }

        $pdf->SetFont('helvetica', '', 12);

        // Contract Header
        $html  = '<h2 style="text-align:center;">' . strtoupper($contract->title) . '</h2>';

        // Candidate & Company Info
        $html .= '<table cellpadding="5" cellspacing="0" style="width: 100%; border: 1px solid #ddd;">
            <tr>
                <td width="50%" valign="top">
                    <strong>CANDIDATE DETAILS</strong><br><br>
                    <strong>Name:</strong> ' . $contract->first_name . ' ' . $contract->last_name . '<br>
                    <strong>Email:</strong> ' . $contract->email . '<br>
                    <strong>Phone:</strong> ' . $contract->phone . '<br>
                    <strong>Address:</strong> ' . $contract->address . '
                </td>
                <td width="50%" valign="top">
                    <strong>COMPANY DETAILS</strong>' .
                    nl2br(!empty($contract->company_info) ? $contract->company_info : 'Company information not provided') . '
                </td>
            </tr>
        </table><br><br>';

        // Contract Terms
        if (!empty($contract->details)) {
            $html .= '<h3>Contract Terms</h3>
                <div style="padding: 15px;">'
                . $contract->details .
                '</div><br><br>';
        }

        // Signature Section
        $html .= '<table cellpadding="10" cellspacing="0" style="width: 100%; margin-top: 50px;">
            <tr>
                <td width="50%" style="text-align: center;">
                    <strong>Candidate Signature</strong><br><br>';
        if (!empty($signature_file_path) && file_exists(FCPATH . $signature_file_path)) {
            $html .= '<img src="' . FCPATH . $signature_file_path . '" style="width: 150px; height: 42px; border: 1px solid #ddd;" />';
        } else {
            $html .= '<div style="border: 1px solid #ddd; height: 100px; width: 200px; margin: 0 auto; background-color: #f9f9f9;"></div>';
        }
        $html .= '<br><br><div style="border-top: 1px solid #333; width: 200px; margin: 0 auto;"></div><small>Signature</small>
                </td>
                <td width="50%" style="text-align: center;">
                    <strong>Date</strong><br><br>
                    <div style="border: 1px solid #ddd; height: 100px; width: 200px; margin: 0 auto; background-color: #f9f9f9; display: flex; align-items: center; justify-content: center;">'
                    . date('F j, Y') .
                    '</div>
                    <br><br><div style="border-top: 1px solid #333; width: 200px; margin: 0 auto;"></div><small>Date</small>
                </td>
            </tr>
        </table>';

        $pdf->writeHTML($html, true, false, true, false, '');

        // 🟥 Last Page
        if (!empty($contract->last_image) && file_exists(FCPATH . 'uploads/hr/contract_template/' . $contract->last_image)) {
            $pdf->AddPage();
            $pdf->Image(FCPATH . 'uploads/hr/contract_template/' . $contract->last_image, 0, 0, 210, 297, '', '', '', true, 300);
        }

        // Save final signed PDF
        $pdf_filename = 'signed_contract_' . $contract_id . '_' . time() . '.pdf';
        $pdf_path = FCPATH . 'uploads/hr/signed_contracts/' . $pdf_filename;

        if (!is_dir(dirname($pdf_path))) {
            mkdir(dirname($pdf_path), 0755, true);
        }

        $pdf->Output($pdf_path, 'F');

        // Send signed PDF via email
        $this->send_signed_contract_email($contract, $pdf_path, $pdf_filename);

        return true;
    }

    private function send_signed_contract_email($contract, $pdf_path, $pdf_filename)
    {
        // Load email helper
        $this->load->helper('hr_email');
        
        // Prepare email content
        $to = $contract->email;
        $subject = 'Your Signed Contract - ' . $contract->title;
        
        $body = '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">';
        $body .= '<h2 style="color: #333; text-align: center;">Contract Successfully Signed</h2>';
        $body .= '<p>Dear ' . $contract->first_name . ' ' . $contract->last_name . ',</p>';
        $body .= '<p>Thank you for signing the contract. Please find attached a copy of your signed contract for your records.</p>';
        $body .= '<p><strong>Contract Details:</strong></p>';
        $body .= '<ul>';
        $body .= '<li><strong>Title:</strong> ' . $contract->title . '</li>';
        $body .= '<li><strong>Signed Date:</strong> ' . date('F j, Y') . '</li>';
        $body .= '<li><strong>Status:</strong> Processing</li>';
        $body .= '</ul>';
        $body .= '<p>If you have any questions regarding this contract, please contact our HR department.</p>';
        $body .= '<p>Best regards,<br>HR Team</p>';
        $body .= '</div>';
        
        // Send email with PDF attachment
        $attachment = $pdf_path;
        $result = hr_send_email($to, $subject, $body, $attachment);
        
        // Log email result (optional)
        if ($result) {
            log_message('info', 'Signed contract email sent successfully to: ' . $to);
        } else {
            log_message('error', 'Failed to send signed contract email to: ' . $to);
        }
        
        return $result;
    }

    



    


}
