<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contract extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/contract_model');
        $this->load->model('hr/candidate_model');
        $this->load->model('hr/candidate_contract_model');
    }

 public function check_expired_contracts()
    {
        // Current date
        $today = date('Y-m-d');

        // Update all contracts jeni date current date karta purani che
        $this->db->where('date <', $today);
        $this->db->where('status !=', 'expired');
        $this->db->update('tblhr_candidate_contracts', ['status' => 'expired']);

        // Optional: log or echo for cron verification
        echo "Expired contracts updated on " . date('Y-m-d H:i:s');
    }


    // public function index()
    // {
    //     $this->load->model('hr/Department_model');
    //     $this->load->model('hr/Designation_model');

    //     $data['departments'] = $this->Department_model->get_all();
    //     $data['designations'] = $this->Designation_model->get_all();

    //     // Initialize filters
    //     $filters = [];

    //     $status = $this->input->get('status');
    //     $department = $this->input->get('department_type');
    //     $designation = $this->input->get('designation_type');

    //     if (!empty($status)) {
    //         $filters['cc.status'] = $status;
    //     }

    //     if (!empty($department)) {
    //         $filters['ca.department_type'] = $department;
    //     }

    //     if (!empty($designation)) {
    //         $filters['ca.designation_type'] = $designation;
    //     }

    //     $data['title'] = _l('hr_contracts');
    //     $data['contracts'] = $this->contract_model->all($filters);

    //     // Simplify filters for pre-select in view
    //     $data['filters'] = [
    //         'status' => $status ?? '',
    //         'department_type' => $department ?? '',
    //         'designation_type' => $designation ?? ''
    //     ];

        

    //     $this->load->view('contracts/manage', $data);
    // }


    public function index()
{
    $this->load->model('hr/Department_model');
    $this->load->model('hr/Designation_model');

    $data['departments'] = $this->Department_model->get_all();
    $data['designations'] = $this->Designation_model->get_all();

    // Initialize filters
    $filters = [];

    $status = $this->input->get('status');
    $department = $this->input->get('department_type');
    $designation = $this->input->get('designation_type');

    if (!empty($status)) {
        $filters['cc.status'] = $status;
    }

    if (!empty($department)) {
        $filters['ca.department_type'] = $department;
    }

    if (!empty($designation)) {
        $filters['ca.designation_type'] = $designation;
    }

    $data['title'] = _l('hr_contracts');

    // 📘 Normal (active) contracts
    $filters['is_history'] = 0; // show only active
    $data['contracts'] = $this->contract_model->all($filters);

    // 📙 History contracts (expired/rejected + 30 days old)
    // $this->db->where('is_history', 1);
    // $data['history_contracts'] = $this->db->get('tblhr_candidate_contracts')->result();

    // Simplify filters for pre-select in view
    $data['filters'] = [
        'status' => $status ?? '',
        'department_type' => $department ?? '',
        'designation_type' => $designation ?? ''
    ];

    $this->load->view('contracts/manage', $data);
}
// public function history()
// {
//     $this->load->model('hr/Department_model');
//     $this->load->model('hr/Designation_model');

//     $data['departments'] = $this->Department_model->get_all();
//     $data['designations'] = $this->Designation_model->get_all();

//     $status = $this->input->get('status');
//     $department = $this->input->get('department_type');
//     $designation = $this->input->get('designation_type');

//     $filters = [];

//     if (!empty($status)) {
//         $filters['ca.status'] = $status;
//     }

//     if (!empty($department)) {
//         $filters['ca.department_type'] = $department;
//     }

//     if (!empty($designation)) {
//         $filters['ca.designation_type'] = $designation;
//     }

//     $data['title'] = _l('hr_contracts');

//     // ✅ Join all 3 tables properly
//     $this->db->select('cc.title, ca.id, ca.status, ca.is_history, c.first_name, c.last_name');
//     $this->db->from('tblhr_candidate_contracts AS ca');
//     $this->db->join('tblhr_contracts AS cc', 'cc.id = ca.contract_id', 'left');
//     $this->db->join('tblhr_candidates AS c', 'c.id = ca.candidate_id', 'left');
//     $this->db->where('ca.is_history', 1);

//     if (!empty($filters)) {
//         $this->db->where($filters);
//     }

//     $data['history_contracts'] = $this->db->get()->result();

//     $data['filters'] = [
//         'status' => $status ?? '',
//         'department_type' => $department ?? '',
//         'designation_type' => $designation ?? ''
//     ];

//     $this->load->view('contracts/history', $data);
// }

public function history()
{
    $this->load->model('hr/Department_model');
    $this->load->model('hr/Designation_model');

    $data['departments'] = $this->Department_model->get_all();
    $data['designations'] = $this->Designation_model->get_all();

    $filters = [];
    $status = $this->input->get('status');
    $department = $this->input->get('department_type');
    $designation = $this->input->get('designation_type');

    if (!empty($status)) {
        $filters['ca.status'] = $status;
    }
    if (!empty($department)) {
        $filters['cand.department_type'] = $department;
    }
    if (!empty($designation)) {
        $filters['cand.designation_type'] = $designation;
    }

    $this->db->select('
        ca.id,
        c.title,
        ca.status,
        ca.date,
        ca.created_at,
        ca.is_history,
        cand.first_name,
        cand.last_name,
        cand.phone,
        cand.email,
        d.name as department_name,
        ds.name as designation_name,
        s.firstname AS created_by_first,
        s.lastname AS created_by_last
    ');
    $this->db->from('tblhr_candidate_contracts AS ca');
    $this->db->join('tblhr_contracts AS c', 'c.id = ca.contract_id', 'left');
    $this->db->join('tblhr_candidates AS cand', 'cand.id = ca.candidate_id', 'left');
    $this->db->join('tblhr_departments AS d', 'd.id = cand.department_type', 'left');
    $this->db->join('tblhr_designations AS ds', 'ds.id = cand.designation_type', 'left');
    $this->db->join('tblstaff AS s', 's.staffid = c.created_by', 'left');
    $this->db->where('ca.is_history', 1);

    if (!empty($filters)) {
        $this->db->where($filters);
    }

    $data['history_contracts'] = $this->db->get()->result_array();

    $data['filters'] = [
        'status' => $status ?? '',
        'department_type' => $department ?? '',
        'designation_type' => $designation ?? ''
    ];

    $data['title'] = _l('Contract History');
    $this->load->view('contracts/history', $data);
}













    public function get_status($id){
        
        $this->load->model('contract_model');
        $record = $this->contract_model->get_by_id($id);
        echo json_encode($record);
    }

    // public function update_status(){
    //     $id = $this->input->post('id');
    //     $status = $this->input->post('status');
    //     $date = $this->input->post('date');

    //     $this->load->model('candidate_contract_model');
    //     $updated = $this->candidate_contract_model->update($id, ['status' => $status, 'date' => $date]);

    //     echo json_encode(['success' => $updated]);
    // }

    // public function update_status() {
    //     $id     = $this->input->post('id');
    //     $status = $this->input->post('status');
    //     $date   = $this->input->post('date');

    //     $this->load->model('candidate_contract_model');
    //     $this->load->model('email_template_model'); 
    //     $this->load->model('candidate_model'); 
    //     $this->load->helper('hr_email'); 
    //     $this->load->helper('string'); // for random password

    //     // 1. Update candidate contract
    //     $updated = $this->candidate_contract_model->update($id, [
    //         'status' => $status,
    //         'date'   => $date
    //     ]);

    //     if ($updated) {
    //         // Map status → slug
    //         $slug_map = [
    //             'draft'    => 'new-contract',
    //             'approved' => 'approve-contract',
    //             'rejected' => 'rejection-contract',
    //         ];

    //         if (isset($slug_map[$status])) {
    //             $slug = $slug_map[$status];

    //             // 2. Fetch email template
    //             $template = $this->email_template_model->get_by_slug($slug);

    //             if ($template) {
    //                 $subject = $template->subject;
    //                 $body    = $template->body;

    //                 // 3. Get candidate details
    //                 $contract     = $this->candidate_contract_model->get($id);
    //                 $candidate_id = $contract->candidate_id;
    //                 $candidate    = $this->candidate_model->get($candidate_id);
    //                 $to           = $candidate->email;

    //                 // Default replacements
    //                 $replacements = [
    //                     '{first_name}' => $candidate->first_name,
    //                     '{last_name}'  => $candidate->last_name,
    //                 ];

    //                 // 4. If approved → insert into tblstaff
    //                 if ($status === 'approved') {
    //                     // check if staff already exists
    //                     $existing = $this->db->where('email', $candidate->email)
    //                                         ->get('tblstaff')
    //                                         ->row();

    //                     if (!$existing) {
    //                         $random_password = random_string('alnum', 10);
    //                         $hashed_password = password_hash($random_password, PASSWORD_BCRYPT);

    //                         $staff_data = [
    //                             'firstname'   => $candidate->first_name,
    //                             'lastname'    => $candidate->last_name,
    //                             'email'       => $candidate->email,
    //                             'phonenumber' => $candidate->phone,
    //                             'password'    => $hashed_password,
    //                             'datecreated' => date('Y-m-d H:i:s'),
    //                             'active'      => 1,
    //                         ];

    //                         $this->db->insert('tblstaff', $staff_data);
    //                         $staff_id = $this->db->insert_id();

    //                         // update candidate table with staff_id
    //                         $this->db->where('id', $candidate->id)
    //                                 ->update('tblhr_candidates', ['staff_id' => $staff_id]);

    //                         // append password in email (HTML-friendly)
    //                         $body .= "<br><br>Your login credentials:<br>Email: {$candidate->email}<br>Password: {$random_password}<br>Please change your password after first login.";
    //                     } else {
    //                         // link candidate to existing staff
    //                         $this->db->where('id', $candidate->id)
    //                                 ->update('tblhr_candidates', ['staff_id' => $existing->staffid]);
    //                     }
    //                 }

    //                 // 5. Replace placeholders in subject/body
    //                 $subject = strtr($subject, $replacements);
    //                 $body    = strtr($body, $replacements);

    //                 // ✅ Append login credentials if new staff was created
    //                 if ($status === 'approved' && isset($random_password)) {
    //                     $body .= "<br><br>Your login credentials:<br>Email: {$candidate->email}<br>Password: {$random_password}<br>Please change your password after first login.";
    //                 }

    //                 var_dump($body); exit;

    //                 // 6. Send email
    //                 hr_send_email($to, $subject, $body);
    //             }
    //         }
    //     }

    //     echo json_encode(['success' => $updated]);
    // }

    public function update_status() {
        $id     = $this->input->post('id');
        $status = $this->input->post('status');
        $date   = $this->input->post('date');

        $this->load->model('candidate_contract_model');
        $this->load->model('email_template_model'); 
        $this->load->model('candidate_model'); 
        $this->load->helper('hr_email'); 
        $this->load->helper('string'); // for random password

        // 1. Update candidate contract
        $updated = $this->candidate_contract_model->update($id, [
            'status' => $status,
            'date'   => $date
        ]);

        if ($updated) {
            // Map status → slug
            $slug_map = [
                'draft'    => 'new-contract',
                'approved' => 'approve-contract',
                'rejected' => 'rejection-contract',
                'expired'  => 'reminder-contract',
                'open'     => 'renew-contract',
            ];

            if (isset($slug_map[$status])) {
                $slug = $slug_map[$status];

                // 2. Fetch email template
                $template = $this->email_template_model->get_by_slug($slug);

                if ($template) {
                    $subject = $template->subject;
                    $body    = $template->body;

                    // 3. Get candidate details
                    $contract     = $this->candidate_contract_model->get($id);
                    $candidate_id = $contract->candidate_id;
                    $candidate    = $this->candidate_model->get($candidate_id);
                    $to           = $candidate->email;

                    // Default replacements
                    $replacements = [
                        '{first_name}' => $candidate->first_name,
                        '{last_name}'  => $candidate->last_name,
                    ];
                    // dd($status);
                    // 4. If approved → insert into tblstaff
                    if ($status === 'approved') {
                        // check if staff already exists
                        $existing = $this->db->where('email', $candidate->email)
                                            ->get('tblstaff')
                                            ->row();
                        if (!$existing) {
                            // generate random password
                            $random_password = random_string('alnum', 10);
                            $hashed_password = password_hash($random_password, PASSWORD_BCRYPT);

                            $staff_data = [
                                'firstname'   => $candidate->first_name,
                                'lastname'    => $candidate->last_name,
                                'email'       => $candidate->email,
                                'phonenumber' => $candidate->phone,
                                'password'    => $hashed_password,
                                'datecreated' => date('Y-m-d H:i:s'),
                                'active'      => 1,
                            ];

                            $this->db->insert('tblstaff', $staff_data);
                            $staff_id = $this->db->insert_id();

                            // update candidate table with staff_id
                            $this->db->where('id', $candidate->id)
                                    ->update('tblhr_candidates', ['staff_id' => $staff_id]);

                            // append password in email body (HTML-friendly)
                            $body = $body . "<br><br>Your login credentials:<br>Email: {$candidate->email}<br>Password: {$random_password}<br>Please change your password after first login.";
                        } else {
                            // link candidate to existing staff
                            $this->db->where('id', $candidate->id)
                                    ->update('tblhr_candidates', ['staff_id' => $existing->staffid]);
                        }
                    }

                    // 5. Replace placeholders in subject/body
                    $subject = strtr($subject, $replacements);
                    $body    = strtr($body, $replacements);
                    // var_dump($body); exit;
                    // 6. Send email
                    hr_send_email($to, $subject, $body);
                }
            }
        }

        echo json_encode(['success' => $updated]);
    }

    // public function bulk_update_status(){
    //     $status = $this->input->post('status');
    //     $contract_ids = json_decode($this->input->post('contract_ids'), true);
        
    //     if (empty($contract_ids) || !is_array($contract_ids)) {
    //         echo json_encode(['success' => false, 'message' => 'No contracts selected']);
    //         return;
    //     }
        
    //     if (!in_array($status, ['approved', 'rejected'])) {
    //         echo json_encode(['success' => false, 'message' => 'Invalid status']);
    //         return;
    //     }
        
    //     $this->load->model('candidate_contract_model');
    //     $updated_count = 0;
        
    //     foreach ($contract_ids as $id) {
    //         $updated = $this->candidate_contract_model->update($id, ['status' => $status]);
    //         if ($updated) {
    //             $updated_count++;
    //         }
    //     }
        
    //     echo json_encode([
    //         'success' => $updated_count > 0,
    //         'updated_count' => $updated_count,
    //         'message' => $updated_count > 0 ? 'Contracts updated successfully' : 'No contracts were updated'
    //     ]);
    // }

    
    public function bulk_update_status() {
    $status = $this->input->post('status');
    $contract_ids = json_decode($this->input->post('contract_ids'), true);

    if (empty($contract_ids) || !is_array($contract_ids)) {
        echo json_encode(['success' => false, 'message' => 'No contracts selected']);
        return;
    }

    $valid_statuses = ['approved', 'rejected', 'draft'];
    if (!in_array($status, $valid_statuses)) {
        echo json_encode(['success' => false, 'message' => 'Invalid status']);
        return;
    }

    $this->load->model('candidate_contract_model');
    $this->load->model('candidate_model');
    $this->load->model('email_template_model');
    $this->load->helper('hr_email');
    $this->load->helper('string'); // for random password

    $slug_map = [
        'draft'    => 'new-contract',
        'approved' => 'approve-contract',
        'rejected' => 'rejection-contract',
        'expired'  => 'reminder-contract',
        'open'     => 'renew-contract',
    ];

    $updated_count = 0;

    foreach ($contract_ids as $id) {
        // 1. Update contract status
        $updated = $this->candidate_contract_model->update($id, ['status' => $status, 'date' => date('Y-m-d')]);
        if (!$updated) continue;

        $updated_count++;

        if (!isset($slug_map[$status])) continue;
        $slug = $slug_map[$status];

        // 2. Fetch email template
        $template = $this->email_template_model->get_by_slug($slug);
        if (!$template) continue;

        $subject = $template->subject;
        $body = $template->body;

        // 3. Get candidate details
        $contract = $this->candidate_contract_model->get($id);
        $candidate_id = $contract->candidate_id;
        $candidate = $this->candidate_model->get($candidate_id);
        if (!$candidate) continue;

        $to = $candidate->email;

        // 4. Default replacements
        $replacements = [
            '{first_name}' => $candidate->first_name,
            '{last_name}'  => $candidate->last_name,
        ];

        // 5. Handle approved status → insert/update tblstaff
        if ($status === 'approved') {
            $existing = $this->db->where('email', $candidate->email)->get('tblstaff')->row();
            if (!$existing) {
                $random_password = random_string('alnum', 10);
                $hashed_password = password_hash($random_password, PASSWORD_BCRYPT);

                $staff_data = [
                    'firstname'   => $candidate->first_name,
                    'lastname'    => $candidate->last_name,
                    'email'       => $candidate->email,
                    'phonenumber' => $candidate->phone,
                    'password'    => $hashed_password,
                    'datecreated' => date('Y-m-d H:i:s'),
                    'active'      => 1,
                ];

                $this->db->insert('tblstaff', $staff_data);
                $staff_id = $this->db->insert_id();

                $this->db->where('id', $candidate->id)
                         ->update('tblhr_candidates', ['staff_id' => $staff_id]);

                // Append login info in email
                $body .= "<br><br>Your login credentials:<br>Email: {$candidate->email}<br>Password: {$random_password}<br>Please change your password after first login.";
            } else {
                $this->db->where('id', $candidate->id)
                         ->update('tblhr_candidates', ['staff_id' => $existing->staffid]);
            }
        }

        // 6. Replace placeholders
        $subject = strtr($subject, $replacements);
        $body = strtr($body, $replacements);

        // 7. Send email
        hr_send_email($to, $subject, $body);
    }

    echo json_encode([
        'success' => $updated_count > 0,
        'updated_count' => $updated_count,
        'message' => $updated_count > 0 ? 'Contracts updated successfully' : 'No contracts were updated'
    ]);
}

    
    public function create()
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'candidate_id' => (int)($post['candidate_id'] ?? null),
                'title' => trim($post['title'] ?? ''),
                'contract_type' => trim($post['contract_type'] ?? 'employment'),
                'start_date' => trim($post['start_date'] ?? null),
                'end_date' => trim($post['end_date'] ?? null),
                'salary' => $post['salary'] !== '' ? (float)$post['salary'] : null,
                'currency' => trim($post['currency'] ?? ''),
                'status' => trim($post['status'] ?? 'draft'),
                'file_path' => trim($post['file_path'] ?? ''),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/contract/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'contract_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $contractData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $contractData['file_path'] = '';
                }
            } else {
                $contractData['file_path'] = '';
            }

            $id = $this->contract_model->add($contractData);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract'));
        }

        $data['title'] = _l('hr_new_contract');
        $data['candidates_kv'] = array_column($this->candidate_model->all(), 'first_name', 'id');
        $this->load->view('contracts/add_edit', $data);
    }

    public function edit($id)
    {
        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $contractData = [
                'candidate_id' => (int)($post['candidate_id'] ?? null),
                'title' => trim($post['title'] ?? ''),
                'contract_type' => trim($post['contract_type'] ?? 'employment'),
                'start_date' => trim($post['start_date'] ?? null),
                'end_date' => trim($post['end_date'] ?? null),
                'salary' => $post['salary'] !== '' ? (float)$post['salary'] : null,
                'currency' => trim($post['currency'] ?? ''),
                'status' => trim($post['status'] ?? 'draft'),
            ];

            if($_FILES['file_path']['name']) {
                $uploadPath = FCPATH . 'uploads/hr/candidate/contract/'; // Full path to /uploads directory
                // Ensure the upload folder exists
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                // Handle file upload
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'pdf|doc|docx|txt';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'contract_' . time() . '_' . $_FILES['file_path']['name'];

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('file_path')) {
                    $uploadData = $this->upload->data();
                    $contractData['file_path'] = $uploadData['file_name'];
                } else {
                    set_alert('warning', _l('hr_certificate_upload_failed') . ': ' . $this->upload->display_errors());
                    $contractData['file_path'] = '';
                }
            }

            $success = $this->contract_model->update($id, $contractData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_contract')));
            }
            redirect(admin_url('hr/contract'));
        }

        $data['contract'] = $this->contract_model->get($id);
        if (!$data['contract']) {
            show_404();
        }
        $data['title'] = _l('hr_edit_contract');
        $data['candidates_kv'] = array_column($this->candidate_model->all(), 'first_name', 'id');
        $this->load->view('contracts/add_edit', $data);
    }

    public function delete($id)
    {
        $this->candidate_contract_model->delete($id);
        set_alert('success', _l('deleted', _l('hr_contract')));
        redirect(admin_url('hr/contract'));
    }
}
