<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cron_hr extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Custom cron for expiring candidate contracts
    public function expire_contracts()
    {
        $today = date('Y-m-d');

        $this->db->where('date <', $today);
        $this->db->where('status !=', 'expired');
        $this->db->update('tblhr_candidate_contracts', ['status' => 'expired']);

        $affected = $this->db->affected_rows();

        echo 'Contracts expired: ' . $affected . ' on ' . $today;
    }

    public function update_history()
    {
        // Get date 30 days ago
        $thirty_days_ago = date('Y-m-d', strtotime('-30 days'));

        // Fetch contracts older than 30 days with status expired or reject
        $this->db->where('date <', $thirty_days_ago);
        $this->db->where_in('status', ['expired', 'reject']);
        $contracts = $this->db->get('tblhr_candidate_contracts')->result_array();

        if (!empty($contracts)) {
            foreach ($contracts as $c) {
                // Mark them for history (if you have a flag field)
                $this->db->where('id', $c['id']);
                $this->db->update('tblhr_candidate_contracts', ['is_history' => 1]);
            }
        }

        echo "History updated successfully. Found " . count($contracts) . " records.";
    }
}
