<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Department_designation extends AdminController
{
    public function __construct() {
        parent::__construct();
        if (!is_admin()) {
            access_denied('hr');
        }
        $this->load->model('hr/Department_model');
        $this->load->model('hr/Designation_model');
    }

    // Departments CRUD
     public function department() {
        $data['title'] = _l('hr_departments');
        $data['departments'] = $this->Department_model->get_all();
        $this->load->view('hr/department/manage', $data); // Make sure path matches view folder
    }

    // Add/Edit Department
    public function add_edit($id = '') {
        if ($this->input->post()) {
            $data = [
                'name' => $this->input->post('name'),
            ];

            if ($id == '') {
                $this->Department_model->insert($data);
                set_alert('success', _l('added_successfully', _l('department')));
            } else {
                $this->Department_model->update($id, $data);
                set_alert('success', _l('updated_successfully', _l('department')));
            }

            redirect(admin_url('hr/department_designation/department'));
        }

        // Load single department for editing
        if ($id != '') {
            $data['department'] = $this->Department_model->get($id);
        }

        $data['title'] = _l('Add/Edit Department');
        $this->load->view('hr/department/add_edit', $data);
    }

    // Delete department
    public function delete_department($id) {
        $this->Department_model->delete($id);
        set_alert('success', _l('deleted', _l('department')));
        redirect(admin_url('hr/department_designation/department'));
    }


    // Designations CRUD
    public function designations() {
        $data['title'] = _l('hr_designations');
        $data['designations'] = $this->Designation_model->get_all();
        $this->load->view('hr/designation/manage', $data);
    }

     public function add_edit_designation($id = null)
{
    $data['title'] = $id ? 'Edit Designation' : 'New Designation';

    // Load existing designation if editing
    if ($id) {
        $data['designation'] = $this->Designation_model->get($id);
        if (!$data['designation']) {
            set_alert('danger', 'Designation not found.');
            redirect(admin_url('hr/department_designation/designations'));
        }
    }

    if ($this->input->post()) {
        $insert_data = [
            'name' => $this->input->post('name'),
        ];

        if ($id) {
            $result = $this->Designation_model->update($id, $insert_data);
            if ($result) {
                set_alert('success', 'Designation updated successfully.');
            } else {
                set_alert('danger', 'Failed to update the designation.');
            }
        } else {
            $result = $this->Designation_model->insert($insert_data);
            if ($result['status']) {
                set_alert('success', 'Designation added successfully.');
            } else {
                set_alert('danger', $result['message'] ?? 'Failed to add the designation.');
            }
        }

        redirect(admin_url('hr/department_designation/designations'));
    }

    $this->load->view('hr/designation/add_edit', $data);
}


    public function delete_designation($id) {
        $this->Designation_model->delete($id);
        redirect('hr/department_designation/designations');
    }
}