<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: HR
Description: Human Resources module
Version: 1.0.0
Requires at least: 2.3.*
*/

define('HR_MODULE_NAME', 'hr');
define('HR_ASSETS_PATH', 'modules/hr/assets');

/**
 * Load custom styles
 */
hooks()->add_action('app_admin_head', 'hr_styles');
function hr_styles()
{
    echo '<link href="' . module_dir_url('hr', 'assets/css/style.css') . '" rel="stylesheet" type="text/css">';
}

/**
 * Register activation hook
 */
register_activation_hook(HR_MODULE_NAME, 'hr_module_activation_hook');
function hr_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files
 */
register_language_files(HR_MODULE_NAME, [HR_MODULE_NAME]);

/**
 * Initialize HR module sidebar menu
 */
hooks()->add_action('admin_init', 'hr_module_init_menu_items');
function hr_module_init_menu_items()
{
    $CI = &get_instance();

    // Parent HR menu
    $CI->app_menu->add_sidebar_menu_item('hr-module', [
        'name'     => _l('hr'),
        'href'     => admin_url('hr/hr'),
        'position' => 50,
        'icon'     => 'fa fa-users',
    ]);

    // Candidates
    if (has_permission('hr_candidates', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-candidates',
            'name'     => _l('hr_candidates'),
            'href'     => admin_url('hr/candidate'),
            'position' => 1,
        ]);
    }

    // Contract Templates
    if (has_permission('hr_contracts', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-contracts-template',
            'name'     => _l('hr_contracts_template'),
            'href'     => admin_url('hr/contract_template'),
            'position' => 2,
        ]);
    }

    // Contracts
    if (has_permission('hr_contracts', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-contracts',
            'name'     => _l('hr_contracts'),
            'href'     => admin_url('hr/contract'),
            'position' => 3,
        ]);
    }

    // Assignments
    if (has_permission('hr_assignments', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-assignments',
            'name'     => _l('hr_assignments'),
            'href'     => admin_url('hr/assignment'),
            'position' => 4,
        ]);
    }

    // Candidate Assignment (dynamic project link)
    $staff_id = get_staff_user_id();
    $CI->db->select('pm.id as project_member_id');
    $CI->db->from('tblproject_members as pm');
    $CI->db->where('pm.staff_id', $staff_id);
    $CI->db->limit(1);
    $project = $CI->db->get()->row_array();

    if ($project && has_permission('hr_assignments', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-candidate-assignment-' . $project['project_member_id'],
            'name'     => _l('hr_candidate_assignments'),
            'href'     => admin_url('hr/candidate_assignment/upload/' . $project['project_member_id']),
            'position' => 5,
        ]);
    }

    // Departments
    if (has_permission('hr_departments', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-departments',
            'name'     => _l('hr_departments'),
            'href'     => admin_url('hr/department_designation/department'),
            'position' => 6,
        ]);
    }

    // Designations
    if (has_permission('hr_designations', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-designations',
            'name'     => _l('hr_designations'),
            'href'     => admin_url('hr/department_designation/designations'),
            'position' => 7,
        ]);
    }

    // Certificates
    if (has_permission('hr_certificates', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-certifications',
            'name'     => _l('hr_certifications_templates'),
            'href'     => admin_url('hr/certificate_template'),
            'position' => 8,
        ]);
    }

    // Email Templates
    if (has_permission('hr_email_templates', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('hr-module', [
            'slug'     => 'hr-email-templates',
            'name'     => _l('hr_email_templates'),
            'href'     => admin_url('hr/email_templates'),
            'position' => 9,
        ]);
    }
}

/**
 * Register HR module permissions
 */
hooks()->add_action('admin_init', 'hr_module_permissions');
function hr_module_permissions()
{
    $all_hr_permissions = [
        'hr' => _l('hr'),
        'hr_candidates' => _l('hr_candidates'),
        'hr_contracts' => _l('hr_contracts'),
        'hr_certificates' => _l('Certificates'),
        'hr_assignments' => _l('hr_assignments'),
        'hr_departments' => _l('hr_departments'),
        'hr_designations' => _l('hr_designations'),
        'hr_email_templates' => _l('hr_email_templates'),
    ];

    foreach ($all_hr_permissions as $slug => $label) {
        register_staff_capabilities($slug, [
            'capabilities' => [
                'view'   => _l('permission_view'),
                'create' => _l('permission_create'),
                'edit'   => _l('permission_edit'),
                'delete' => _l('permission_delete'),
            ],
        ], $label);
    }
}
