<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Assignment_comment_model  extends App_Model
{
    protected $table = 'tblhr_assignment_comments';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Add a new comment
     *
     * @param array $data ['assignment_id' => ..., 'staff_id' => ..., 'comment' => ...]
     * @return int Inserted comment ID
     */
    public function add_comment($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Get comments for a specific assignment
     *
     * @param int $assignment_id
     * @return array
     */
    public function get_comments_by_assignment($assignment_id)
    {
        $this->db->where('assignment_id', $assignment_id);
        $this->db->order_by('created_at', 'ASC');
        return $this->db->get($this->table)->result_array();
    }

    /**
     * Optional: delete a comment
     *
     * @param int $comment_id
     * @return bool
     */
    public function delete_comment($comment_id)
    {
        return $this->db->delete($this->table, ['id' => $comment_id]);
    }

}
