<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_client_model extends App_Model
{
    protected $table = 'tblhr_candidate_otps'; // Create this table

    public function save_otp($email, $otp)
    {
        // Remove old OTPs for same email
        $this->db->where('email', $email);
        $this->db->delete($this->table);

        $data = [
            'email'      => $email,
            'otp'        => $otp,
            'created_at' => date('Y-m-d H:i:s'),
        ];
        $this->db->insert($this->table, $data);
    }

    public function verify_otp($email, $otp)
    {
        // var_dump($email, $otp); die;
        $this->db->where('email', $email);
        $this->db->where('otp', $otp);
        $this->db->where('created_at >=', date('Y-m-d H:i:s', strtotime('-10 minutes'))); // OTP valid 10 mins
        $row = $this->db->get($this->table)->row();

        return $row ? true : false;
    }

    public function get_by_email($email)
    {
        return $this->db
                    ->get_where(db_prefix() . 'hr_candidates', ['email' => $email])
                    ->row();
    }

    public function get_contract_by_id($contract_id)
    {
        return $this->db
                    ->get_where(db_prefix() . 'hr_contracts', ['id' => $contract_id])
                    ->row();
    }

    // public function get_certificate_by_id($certificate_id)
    // {
    //     return $this->db
    //                 ->get_where(db_prefix() . 'hr_certifications', ['certificate_type' => $certificate_id])
    //                 ->row();
    // }

   public function get_certificate_by_id($certificate_id)
{
    return $this->db
        ->select('
            hc.*, 
            hct.title AS template_title, 
            hct.details AS template_details, 
            hct.background_image AS template_background,
            CONCAT(cand.first_name, " ", cand.last_name) AS candidate_name,
            cand.email
        ')
        ->from(db_prefix() . 'hr_certifications AS hc')
        ->join(db_prefix() . 'hr_certificate_template AS hct', 'hct.id = hc.certificate_type', 'left')
        ->join(db_prefix() . 'hr_candidates AS cand', 'cand.id = hc.candidate_id', 'left')
        ->where('hc.certificate_type', $certificate_id)
        ->get()
        ->row();
}





    public function get_candidate_contracts($candidate_id)
    {
        $this->db->select('cc.*,c.title, c.details, c.cover_image, c.background_image, c.last_image, c.fields_list,ca.first_name, ca.last_name, ca.email, ca.phone, ca.created_by as candidate_created_by');
        $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
        $this->db->join(db_prefix() . 'hr_contracts as c', 'c.id = cc.contract_id', 'inner');
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');   
        $this->db->where('cc.candidate_id', $candidate_id);
        return $this->db->get()->result();
    }

    public function get_candidate_certificates($candidate_id)
    {
        $this->db->select('t.*, ca.first_name, ca.last_name, ca.email, ca.phone, ca.created_by as candidate_created_by');
        $this->db->from(db_prefix() . 'hr_certificate_template as t'); // templates table
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = '.$candidate_id, 'left'); // candidate info
        return $this->db->get()->result();
    }

    public function update_candidate_status($id, $status)
    {
        $data = [
            'status' => $status,
            'updated_at' => date('Y-m-d H:i:s')
        ];
        $this->db->where('id', $id);
        return $this->db->update(db_prefix() . 'hr_candidate_contracts', $data);
    }

    public function get_candidate_by_contract_by_id($contract_id)
    {
        $this->db->select('ca.first_name, ca.last_name, ca.email, ca.phone, ca.created_by as candidate_created_by');
        $this->db->from(db_prefix() . 'hr_candidate_contracts as cc');
        $this->db->join(db_prefix() . 'hr_candidates as ca', 'ca.id = cc.candidate_id', 'inner');   
        $this->db->where('cc.id', $contract_id);
        return $this->db->get()->row();
    }

    


}
