<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Department_model extends App_Model {

    protected $table = 'tblhr_departments';
    protected $primaryKey = 'id'; // use the actual column name

    public function __construct()
    {
        parent::__construct();
    }

    public function get_all() {
        return $this->db->get($this->table)->result_array();
    }

    public function get($id) {
        return $this->db->get_where($this->table, [$this->primaryKey => $id])->row();
    }

    public function insert($data) {
        $insert = $this->db->insert($this->table, $data);
        if (!$insert) {
            log_message('error', 'DB Insert Error: ' . print_r($this->db->error(), true));
        }
        return $insert;
    }

    public function update($id, $data) {
        return $this->db->where($this->primaryKey, $id)->update($this->table, $data);
    }

    public function delete($id) {
        return $this->db->delete($this->table, [$this->primaryKey => $id]);
    }
}
