<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700">Submission of Assignments</h4>
                <!-- <form action="<?php echo admin_url('hr/candidate_assignment/submit_assignment'); ?>" method="post" enctype="multipart/form-data">
                        <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

                    <div class="panel_s">
                        <div class="panel-body">
                            <div class="row">
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <h4>Project Name: <?php echo $project_name; ?></h4>
                                        <input type="hidden" name="project_id" value="<?php echo $project_id; ?>">
                                        <input type="hidden" name="staff_id" value="<?php echo $staff_id; ?>">

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="source_code" class="control-label">Source Code</label>
                                        <input type="file" name="source_code" class="form-control" id="source_code" accept=".zip">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="report" class="control-label">Reports</label>
                                        <input type="file" name="report" class="form-control" id="report" accept=".zip">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="other" class="control-label">Other</label>
                                        <input type="file" name="other" class="form-control" id="other" accept=".zip">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="panel-footer text-right">
                            <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                            <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                        </div>
                    </div>
                </form> -->
                <div class="panel_s">
                    <div class="panel-body">
                        <ul class="nav nav-tabs" role="tablist">
                            <?php $i = 0; foreach ($projects as $project): ?>
                                <li role="presentation" class="<?= $i === 0 ? 'active' : '' ?>">
                                    <a href="#project_<?php echo $project['project_id']; ?>" aria-controls="project_<?php echo $project['project_id']; ?>" role="tab" data-toggle="tab">
                                        <?php echo $project['project_name']; ?>
                                    </a>
                                </li>
                            <?php $i++; endforeach; ?>
                        </ul>

                        <div class="tab-content" style="margin-top: 20px;">
                            <?php $i = 0; foreach ($projects as $project): ?>
                                <div role="tabpanel" class="tab-pane <?= $i === 0 ? 'active' : '' ?>" id="project_<?php echo $project['project_id']; ?>">
                                    <form action="<?php echo admin_url('hr/candidate_assignment/submit_assignment'); ?>" method="post" enctype="multipart/form-data">
                                        <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

                                        <input type="hidden" name="project_id" value="<?php echo $project['project_id']; ?>">
                                        <input type="hidden" name="staff_id" value="<?php echo $staff_id; ?>">

                                        <h4>Project: <?php echo $project['project_name']; ?>
                                                        <span class="label label-<?php 
                                            echo $active_project['status'] == 'approved' ? 'success' : 
                                                ($active_project['status'] == 'rejected' ? 'danger' : 'warning'); ?>">
                                            <?php echo ucfirst($active_project['status']); ?>
                                        </span></h4>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="source_code_<?php echo $project['project_id']; ?>" class="control-label">Source Code (.zip)</label>
                                                    <input type="file" name="source_code" class="form-control" id="source_code_<?php echo $project['project_id']; ?>" accept=".zip">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="report_<?php echo $project['project_id']; ?>" class="control-label">Report (.zip)</label>
                                                    <input type="file" name="report" class="form-control" id="report_<?php echo $project['project_id']; ?>" accept=".zip">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="other_<?php echo $project['project_id']; ?>" class="control-label">Other (.zip)</label>
                                                    <input type="file" name="other" class="form-control" id="other_<?php echo $project['project_id']; ?>" accept=".zip">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="text-right">
                                            <?php if ($active_project): ?>
                                                <a href="<?php echo admin_url('hr/candidate_assignment/request_certificate/' . $staff_id); ?>" 
                                                class="btn btn-success mleft10"
                                                onclick="return confirm('Are you sure you want to request the certificate?');">
                                                    <?php echo _l('Request Certificate'); ?>
                                                </a>
                                            <?php else: ?>
                                                <button type="submit" class="btn btn-primary">
                                                    <?php echo _l('submit'); ?>
                                                </button>
                                            <?php endif; ?>

                                            <a href="<?php echo admin_url('hr/assignment'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                        </div>
                                    </form>
                                </div>
                            <?php $i++; endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php
                function time_elapsed_string($datetime, $full = false) {
                    $now = new DateTime;
                    $ago = new DateTime($datetime);
                    $diff = $now->diff($ago);

                    // Calculate weeks without creating dynamic property
                    $weeks = floor($diff->d / 7);
                    $days = $diff->d - ($weeks * 7);

                    $string = [
                        'y' => 'year',
                        'm' => 'month',
                        'w' => 'week',
                        'd' => 'day',
                        'h' => 'hour',
                        'i' => 'minute',
                        's' => 'second',
                    ];

                    $values = [
                        'y' => $diff->y,
                        'm' => $diff->m,
                        'w' => $weeks,
                        'd' => $days,
                        'h' => $diff->h,
                        'i' => $diff->i,
                        's' => $diff->s,
                    ];

                    foreach ($values as $k => $v) {
                        if ($v) {
                            $string[$k] = $v . ' ' . $string[$k] . ($v > 1 ? 's' : '');
                        } else {
                            unset($string[$k]);
                        }
                    }

                    if (!$full) $string = array_slice($string, 0, 1);
                    return $string ? implode(', ', $string) . ' ago' : 'just now';
                }
                ?>

               <?php foreach ($comments as $comment): 
                    // Decode the JSON stored in 'comment' field
                    $comment_data = json_decode($comment['comment'], true);

                    // Extract text, tags, and attachments safely
                    $comment_text = $comment_data['text'] ?? '<em>No comment</em>';
                    $comment_tags = $comment_data['tags'] ?? [];
                    $comment_attachments = $comment_data['attachments'] ?? [];

                ?>
                <li class="list-group-item">
                    <div class="comment-header">
                        <strong><?php echo get_staff_full_name($comment['staff_id']); ?></strong>
                        <span class="text-muted" style="font-size:12px;">
                            <?php echo time_elapsed_string($comment['created_at']); ?>
                        </span>
                    </div>

                    <div class="comment-body" style="margin-top:5px;">
                        <?php echo $comment_text; ?>
                    </div>

                    <?php if (!empty($comment_tags)): ?>
                        <div class="comment-tags" style="margin-top:5px;">
                            <?php foreach ($comment_tags as $tag): ?>
                                <span class="badge bg-secondary"><?php echo htmlspecialchars($tag); ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($comment_attachments)): ?>
                        <div class="comment-attachments" style="margin-top:5px;">
                            <?php foreach ($comment_attachments as $file): ?>
                                <a href="<?php echo base_url($file); ?>" target="_blank">
                                    <?php echo basename($file); ?>
                                </a><br>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </li>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
document.querySelector('form').addEventListener('submit', function (e) {
    const maxSize = 5 * 1024 * 1024; // 5 MB in bytes
    const fileInputs = ['source_code', 'report', 'other'];

    for (const name of fileInputs) {
        const fileInput = document.getElementById(name);
        if (fileInput && fileInput.files.length > 0) {
            const file = fileInput.files[0];
            const ext = file.name.split('.').pop().toLowerCase();

            if (ext !== 'zip') {
                alert('Only ZIP files are allowed for "' + name + '".');
                e.preventDefault();
                return false;
            }

            if (file.size > maxSize) {
                alert('File "' + file.name + '" exceeds 5MB limit.');
                e.preventDefault();
                return false;
            }
        }
    }
});
</script>

