<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
    <div class="panel-heading">
        <h4 class="panel-title"><?= _l('Certificate'); ?></h4>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?= _l('Certificate Name'); ?></th>
                        <!-- <th><?= _l('Date'); ?></th> -->
                        <th class="text-right"><?= _l('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($certificates)) : ?>
                        <?php foreach ($certificates as $certificate): ?>
                            <tr>
                                <td><?= $certificate->title; ?></td>
                                <!-- <td><?= date('D M d Y', strtotime($certificate->candidate_created_by)); ?></td> -->
                                <td class="text-right">
                                    <a href="<?= site_url('hr/candidate_certificate/sign_certificate/' . $certificate->id); ?>" 
                                    class="btn btn-info btn-sm">
                                        <?= _l('View'); ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="text-center"><?= _l('No contracts found'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>
