<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<style>
.nav-tabs {
    display: flex;
    justify-content: center;
}
.nav-tabs li {
    float: none; /* override default float */
}
</style>

<div class="row">
    <div class="col-md-12">
        <div class="panel_s">
            <div class="panel-heading">
                <h4 class="panel-title"><?= _l('Sign Contract'); ?></h4>
            </div>
            <div class="panel-body">

                <div class="row">
                    <!-- Left Actions -->
                    <div class="col-md-3">
                        <div class="list-group">
                            <a href="javascript:void(0)" class="btn btn-info mb-5" style="width:100%;margin-bottom:10px;" id="add_signature">
                                <?= _l('Add Signature'); ?>
                            </a>
                            <!-- <a href="javascript:void(0)" class=" btn btn-info mb-5" style="width:100%;margin-bottom:10px;" id="add_date">
                                <?= _l('Add Date'); ?>
                            </a> -->
                            <a href="<?= site_url('hr/candidate_client/thank_you/' . $contract->id);?>" class="btn btn-success mb-5"  style="width:100%;margin-bottom:10px;" id="complete_signature">
                                <?= _l('Complete Signing'); ?>
                            </a>
                        </div>
                    </div>

                    <!-- Contract Preview -->
                    <div class="col-md-9 text-center">
                        <iframe src="<?= $pdf_url; ?>" style="width:100%; height:600px; border:1px solid #ddd;" frameborder="0"></iframe>
                    </div>
                </div>

                <!-- Signature Modal -->
                <div class="modal fade" id="signatureModal" tabindex="-1">
                    <div class="modal-dialog modal-md">
                        <div class="modal-content">
                            <div class="modal-body">

                                <!-- Tabs -->
                                <ul class="nav nav-tabs justify-content-center">
                                    <li class="active"><a href="#draw" data-toggle="tab">Draw</a></li>
                                    <li><a href="#type" data-toggle="tab">Type</a></li>
                                    <li><a href="#upload" data-toggle="tab">Upload</a></li>
                                </ul>

                                <input type="hidden" id="contract_id" value="<?= $contract->id; ?>">

                                <div class="tab-content mt-3">
                                    <!-- Draw -->
                                    <div id="draw" class="tab-pane fade in active text-center">
                                        <div class="mb-3">
                                            <button type="button" class="btn btn-primary select-color" data-color="blue" style="width:40px;height:40px;border-radius:11px;"></button>
                                            <button type="button" class="btn btn-danger select-color" data-color="red" style="width:40px;height:40px;border-radius:11px;"></button>
                                            <button type="button" class="btn btn-dark select-color" data-color="black" style="width:40px;height:40px;border-radius:11px;"></button>
                                        </div>
                                        <canvas id="signature-pad" width="500" height="200" style="background:#b7cfce24;"></canvas>
                                        <br>
                                        <button type="button" id="clear" class="btn btn-warning">Clear</button>
                                    </div>

                                    <!-- Type -->
                                    <div id="type" class="tab-pane fade">
                                        <input type="text" id="typedName" placeholder="Enter your name" class="form-control">
                                        <p id="typedSignature" style="font-family:'Dancing Script',cursive;font-size:32px;margin-top:50px;text-align:center;padding:50px;background:#b7cfce24;"></p>
                                    </div>

                                    <!-- Upload -->
                                    <div id="upload" class="tab-pane fade">
                                        <input type="file" id="signatureFile" accept="image/*" class="form-control">
                                        <br>
                                        <img id="preview" src="" alt="Preview" style="max-width:200px;display:none;margin:auto;">
                                    </div>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button id="saveSignature" class="btn btn-success">Save Signature</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>

<script>
$(function () {
    // Open modal -> reset all fields
    $('#add_signature').on('click', function () {
        resetSignatureFields();
        $('#signatureModal').modal('show');
    });

    // Reset function
    function resetSignatureFields() {
        signaturePad.clear(); // clear canvas
        $('#typedName').val('');
        $('#typedSignature').text('');
        $('#signatureFile').val('');
        $('#preview').attr('src', '').hide();
    }

    // Clear canvas button
    $('#clear').click(function () {
        signaturePad.clear();
    });

    // Draw signature (clear others)
    var canvas = document.getElementById('signature-pad');
    signaturePad = new SignaturePad(canvas, { penColor: 'black' });

    signaturePad.onBegin = function () {
        // Clear typed + upload when drawing starts
        $('#typedName').val('');
        $('#typedSignature').text('');
        $('#signatureFile').val('');
        $('#preview').attr('src', '').hide();
    };

    // Change pen color
    $('.select-color').click(function () {
        let color = $(this).data('color');
        signaturePad.penColor = color;
        $('.select-color').removeClass('active');
        $(this).addClass('active');
    });

    // Typed signature (clear others)
    $('#typedName').on('keyup', function () {
        if ($(this).val() !== '') {
            signaturePad.clear();
            $('#signatureFile').val('');
            $('#preview').attr('src', '').hide();
        }
        $('#typedSignature').text($(this).val());
    });

    // Upload signature (clear others)
    $('#signatureFile').on('change', function () {
        if (this.files.length > 0) {
            signaturePad.clear();
            $('#typedName').val('');
            $('#typedSignature').text('');
        }

        let reader = new FileReader();
        reader.onload = function (e) {
            $('#preview').attr('src', e.target.result).show();
        };
        if (this.files[0]) reader.readAsDataURL(this.files[0]);
    });

    var csrfName = "<?php echo $this->security->get_csrf_token_name(); ?>";
    var csrfHash = "<?php echo $this->security->get_csrf_hash(); ?>";
    $('#saveSignature').click(function (e) {
        e.preventDefault();

        let type = '', data = '';

        if (!signaturePad.isEmpty()) {
            type = 'draw';
            data = signaturePad.toDataURL(); // returns base64 (e.g., data:image/png;base64,iVBORw0KGgo...)
        } else if ($('#typedName').val() !== '') {
            type = 'type';
            data = $('#typedSignature').text();
        } else if ($('#signatureFile')[0].files.length > 0) {
            type = 'upload';
        } else {
            alert('Please add a signature first!');
            return;
        }

        let formData = new FormData();
        formData.append('contract_id', $('#contract_id').val());
        formData.append('type', type);
        if (type !== 'upload') formData.append('signature', data);
        if (type === 'upload') formData.append('signatureFile', $('#signatureFile')[0].files[0]);

        formData.append(csrfName, csrfHash);

        $.ajax({
            url: '<?= site_url("hr/candidate_client/save_signature") ?>',
            type: 'POST',
            data: formData, [csrfData.token_name]: csrfData.hash,
            dataType: 'json', // 👈 tell jQuery we expect JSON
            contentType: false,
            processData: false,
            success: function (r) {
                console.log(r);
                if (r.success) {
                    alert('Signature saved successfully! A signed contract PDF has been sent to your email.');
                    window.location.href = '<?= site_url("hr/candidate_client/thank_you/"); ?>'+r.contract_id;
                    $('#signatureModal').modal('hide');
                    csrfHash = r.csrfHash;
                } else {
                    alert('Error: ' + r.error);
                }
            },
            error: function (xhr, status, error) {
                console.error(xhr.responseText);
                alert('AJAX Error: ' + error);
            }
        });
    });
});
</script>

