<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
    .input-group-text {
    font-weight: 500;
    border-left: 0;
}
.input-group {
    display: flex;
}
.input-group-append {
    text-align: center;  
    padding: 5px;
    border: 1px solid #ced4da;
    background-color: #b0b6bd;
    border-radius: 0px 5px 5px 0px
}    
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tab-content tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_candidate_info">
                                <div class="row">
                                    <div class="col-md-12">
                                        <span><b>Name: </b><?php echo isset($candidate) ? ($candidate->first_name.' '.$candidate->last_name) : 'Manya Gupta'; ?></span><br/>
                                        <span><b>Phone: </b><?php echo isset($candidate) ? $candidate->phone : '+91 12345 67890'; ?></span><br/>
                                        <span><b>Email: </b><?php echo isset($candidate) ? $candidate->email : 'manyagupta@gmail.com'; ?></span><br/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="resume" class="control-label"><?= _l('resume'); ?></label>
                                            <input type="file" name="resume" class="form-control" id="resume">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_date_input('valid_date', _l('Valid Through'), isset($candidate) ? $candidate->valid_date : ''); ?>
                                        <?php // echo render_input('resume', _l('hr_candidate_resume'), isset($candidate) ? $candidate->resume : ''); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php echo render_date_input('date_of_birth', _l('Date of Birth'), isset($candidate) ? $candidate->date_of_birth : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('contract_type', [
                                                ['id' => 'hourly', 'name' => _l('Hourly')],
                                                ['id' => 'weekly', 'name' => _l('Weekly')],
                                                ['id' => 'monthly', 'name' => _l('Monthly')]
                                            ], ['id', 'name'], _l('Contract Type'), isset($candidate) ? $candidate->contract_type : 'freelancer'); ?>
                                    </div>
                                </div>
                                <!-- <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="experience">Experience</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="input-group">
                                                        <input type="number" min="0" class="form-control" name="experience_years" id="experience_years" placeholder="0">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text">Years</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 mt-2 mt-md-0">
                                                    <div class="input-group">
                                                        <input type="number" min="0" max="11" class="form-control" name="experience_month" id="experience_month" placeholder="0">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text">Months</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('preferred_job_type', [
                                                ['id' => 'freelancer', 'name' => _l('Freelancer')],
                                                ['id' => 'regular', 'name' => _l('Regular')]
                                            ], ['id', 'name'], _l('Preferred Job Type'), isset($candidate) ? $candidate->preferred_job_type : 'freelancer'); ?>
                                    </div>
                                </div> -->
                                   
                                <?php if (!isset($candidate) || $candidate->employee_type != 'intern'): ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="experience">Experience</label>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group">
                                                            <input type="number" min="0" class="form-control" name="experience_years" id="experience_years" placeholder="0">
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">Years</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mt-2 mt-md-0">
                                                        <div class="input-group">
                                                            <input type="number" min="0" max="11" class="form-control" name="experience_month" id="experience_month" placeholder="0">
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">Months</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_select('preferred_job_type', [
                                                    ['id' => 'freelancer', 'name' => _l('Freelancer')],
                                                    ['id' => 'regular', 'name' => _l('Regular')]
                                                ], ['id', 'name'], _l('Preferred Job Type'), isset($candidate) ? $candidate->preferred_job_type : 'freelancer'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>


                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="rate"> <span class="text-danger">*</span> Rate</label>
                                            <div class="d-flex" style="display: flex;">
                                                <!-- Currency dropdown -->
                                                <select class="form-control w-auto mr-2" name="rate_currency" id="rate_currency">
                                                    <option value="AFN">AFN</option>
                                                    <option value="ALL">ALL</option>
                                                    <option value="DZD">DZD</option>
                                                    <option value="AOA">AOA</option>
                                                    <option value="ARS">ARS</option>
                                                    <option value="AMD">AMD</option>
                                                    <option value="AWG">AWG</option>
                                                    <option value="AUD">AUD</option>
                                                    <option value="AZN">AZN</option>
                                                    <option value="BSD">BSD</option>
                                                    <option value="BHD">BHD</option>
                                                    <option value="BDT">BDT</option>
                                                    <option value="BBD">BBD</option>
                                                    <option value="BYN">BYN</option>
                                                    <option value="BZD">BZD</option>
                                                    <option value="BMD">BMD</option>
                                                    <option value="BTN">BTN</option>
                                                    <option value="BTC">BTC</option>
                                                    <option value="BOB">BOB</option>
                                                    <option value="BAM">BAM</option>
                                                    <option value="BWP">BWP</option>
                                                    <option value="BRL">BRL</option>
                                                    <option value="GBP">GBP</option>
                                                    <option value="BND">BND</option>
                                                    <option value="BGN">BGN</option>
                                                    <option value="BIF">BIF</option>
                                                    <option value="KHR">KHR</option>
                                                    <option value="CAD">CAD</option>
                                                    <option value="CVE">CVE</option>
                                                    <option value="KYD">KYD</option>
                                                    <option value="XOF">XOF</option>
                                                    <option value="XAF">XAF</option>
                                                    <option value="XPF">XPF</option>
                                                    <option value="CLP">CLP</option>
                                                    <option value="CNY">CNY</option>
                                                    <option value="COP">COP</option>
                                                    <option value="KMF">KMF</option>
                                                    <option value="CDF">CDF</option>
                                                    <option value="CRC">CRC</option>
                                                    <option value="HRK">HRK</option>
                                                    <option value="CUC">CUC</option>
                                                    <option value="CZK">CZK</option>
                                                    <option value="DKK">DKK</option>
                                                    <option value="DJF">DJF</option>
                                                    <option value="DOP">DOP</option>
                                                    <option value="XCD">XCD</option>
                                                    <option value="EGP">EGP</option>
                                                    <option value="ERN">ERN</option>
                                                    <option value="ETB">ETB</option>
                                                    <option value="EUR">EUR</option>
                                                    <option value="FKP">FKP</option>
                                                    <option value="FJD">FJD</option>
                                                    <option value="GMD">GMD</option>
                                                    <option value="GEL">GEL</option>
                                                    <option value="GHS">GHS</option>
                                                    <option value="GIP">GIP</option>
                                                    <option value="GTQ">GTQ</option>
                                                    <option value="GNF">GNF</option>
                                                    <option value="GYD">GYD</option>
                                                    <option value="HTG">HTG</option>
                                                    <option value="HNL">HNL</option>
                                                    <option value="HKD">HKD</option>
                                                    <option value="HUF">HUF</option>
                                                    <option value="ISK">ISK</option>
                                                    <option value="INR">INR</option>
                                                    <option value="IDR">IDR</option>
                                                    <option value="IRR">IRR</option>
                                                    <option value="IQD">IQD</option>
                                                    <option value="ILS">ILS</option>
                                                    <option value="JMD">JMD</option>
                                                    <option value="JPY">JPY</option>
                                                    <option value="JOD">JOD</option>
                                                    <option value="KZT">KZT</option>
                                                    <option value="KES">KES</option>
                                                    <option value="KWD">KWD</option>
                                                    <option value="KGS">KGS</option>
                                                    <option value="LAK">LAK</option>
                                                    <option value="LBP">LBP</option>
                                                    <option value="LSL">LSL</option>
                                                    <option value="LRD">LRD</option>
                                                    <option value="LYD">LYD</option>
                                                    <option value="MOP">MOP</option>
                                                    <option value="MKD">MKD</option>
                                                    <option value="MGA">MGA</option>
                                                    <option value="MWK">MWK</option>
                                                    <option value="MYR">MYR</option>
                                                    <option value="MVR">MVR</option>
                                                    <option value="MRU">MRU</option>
                                                    <option value="MUR">MUR</option>
                                                    <option value="MXN">MXN</option>
                                                    <option value="MDL">MDL</option>
                                                    <option value="MNT">MNT</option>
                                                    <option value="MAD">MAD</option>
                                                    <option value="MZN">MZN</option>
                                                    <option value="MMK">MMK</option>
                                                    <option value="NAD">NAD</option>
                                                    <option value="NPR">NPR</option>
                                                    <option value="ANG">ANG</option>
                                                    <option value="TWD">TWD</option>
                                                    <option value="NZD">NZD</option>
                                                    <option value="NIO">NIO</option>
                                                    <option value="NGN">NGN</option>
                                                    <option value="KPW">KPW</option>
                                                    <option value="NOK">NOK</option>
                                                    <option value="OMR">OMR</option>
                                                    <option value="PKR">PKR</option>
                                                    <option value="PAB">PAB</option>
                                                    <option value="PGK">PGK</option>
                                                    <option value="PYG">PYG</option>
                                                    <option value="PEN">PEN</option>
                                                    <option value="PHP">PHP</option>
                                                    <option value="PLN">PLN</option>
                                                    <option value="QAR">QAR</option>
                                                    <option value="RON">RON</option>
                                                    <option value="RUB">RUB</option>
                                                    <option value="RWF">RWF</option>
                                                    <option value="SAR">SAR</option>
                                                    <option value="SDG">SDG</option>
                                                    <option value="SRD">SRD</option>
                                                    <option value="SZL">SZL</option>
                                                    <option value="SEK">SEK</option>
                                                    <option value="CHF">CHF</option>
                                                    <option value="STN">STN</option>
                                                    <option value="VES">VES</option>
                                                    <option value="ZMW">ZMW</option>
                                                </select>

                                                <!-- Amount input -->
                                                <input type="number" class="form-control mr-2" name="rate" id="rate" placeholder="0.00" min="0" step="0.01">

                                                <!-- Duration dropdown -->
                                                <select class="form-control w-auto" name="rate_type" id="rate_type">
                                                    <option value="Hour">Hour</option>
                                                    <option value="Day">Day</option>
                                                    <option value="Month">Month</option>
                                                </select>
                                            </div>
                                        </div>  
                                    </div>
                                    
                                    <!-- <div class="col-md-6">
                                        <?php 
                                            $selected_templates = [];
                                            if (!empty($candidate) && !empty($candidate->template_type)) {
                                                $selected_templates = explode(',', $candidate->template_type);
                                            }

                                            echo render_select(
                                                'template_type[]',
                                                $template_type,
                                                ['id', 'title'],
                                                _l('Template Type'),
                                                $selected_templates,
                                                ['multiple' => true]
                                            ); 
                                        ?>
                                    </div> -->

                                    <div class="col-md-6">
                                        <?php 
                                            $selected_templates = [];
                                            if (!empty($candidate) && !empty($candidate->template_type)) {
                                                $selected_templates = explode(',', $candidate->template_type);
                                            }

                                            // Convert objects to arrays
                                            $template_type_with_create = [];
                                            foreach ($template_type as $t) {
                                                $template_type_with_create[] = (array) $t;
                                            }

                                            // Add static "Create +" option
                                            $template_type_with_create[] = [
                                                'id' => 'create',
                                                'title' => 'Create +'
                                            ];

                                            // Render select with safe ID
                                            echo render_select(
                                                'template_type[]', // name stays same for form
                                                $template_type_with_create,
                                                ['id', 'title'],
                                                _l('Template Type'),
                                                $selected_templates,
                                                [
                                                    'multiple' => true,
                                                    'id' => 'template_type_select' // safe ID
                                                ]
                                            );
                                        ?>

                                    </div>

                                    

                                </div>
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                        <?php echo render_textarea('address', _l('Address'), isset($candidate) ? $candidate->address : '', ['rows' => 4]); ?>
                                    </div>
                                    <!-- <div class="col-md-6">
                                        <label for="template_type"> <span class="text-danger">*</span> Template Type</label>
                                        <select class="form-control w-auto" name="template_type" id="template_type">
                                            <option value="intern">Intern</option>
                                            <option value="employment">Employment</option>
                                            <option value="nda">NDA</option>
                                            
                                        </select>
                                    </div> -->

                                    <div class="col-md-6">
                                        <?php 
                                            $selected_certificates = [];
                                            if (!empty($candidate) && !empty($candidate->certificate_type)) {
                                                $selected_certificates = explode(',', $candidate->certificate_type);
                                            }

                                            echo render_select(
                                            'certificate_type[]',
                                            $certificate_type,
                                            ['id', 'title'],
                                            _l('Certificate Type'),
                                            $selected_certificates,
                                            ['multiple' => true]
                                        );

                                        ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('Send'); ?></button>
                        <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
  const urls = <?= json_encode($redirect_urls ?? []); ?>;

  if (urls.length > 0) {
    urls.forEach(url => window.open(url, '_blank'));
  }

    $(document).ready(function() {
    // Initialize selectpicker
    $('.selectpicker').selectpicker({
        noneSelectedText: 'Nothing selected',
        liveSearch: true,
        actionsBox: false // remove Select All / Deselect All
    });

    // Handle "Create +" option
    $('.selectpicker').on('changed.bs.select', function(e, clickedIndex, isSelected, previousValue) {
        const option = $(this).find('option').eq(clickedIndex);
        
        if(option.val() === 'create' && isSelected) {
            console.log('Create + option selected. Opening new tab...');
            
            // Open new tab for creating contract template
            window.open('<?= admin_url('hr/contract_template'); ?>', '_blank');
            
            // Deselect "Create +" option
            option.prop('selected', false);
            $(this).selectpicker('refresh');
            console.log('"Create +" option deselected');
        }
    });
});



</script>

</script>
