<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_input('first_name', _l('hr_candidate_first_name'), isset($candidate) ? $candidate->first_name : ''); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_input('last_name', _l('hr_candidate_last_name'), isset($candidate) ? $candidate->last_name : ''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_input('phone', _l('hr_candidate_phone'), isset($candidate) ? $candidate->phone : ''); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_input('email', _l('hr_candidate_email'), isset($candidate) ? $candidate->email : '', 'email', ['readonly' => true]); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('skills', _l('hr_candidate_skills'), isset($candidate) ? $candidate->skills : '', ['rows' => 3]); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('education', _l('hr_candidate_education'), isset($candidate) ? $candidate->education : '', ['rows' => 4]); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_textarea('notes', _l('hr_candidate_notes'), isset($candidate) ? $candidate->notes : '', ['rows' => 4]); ?>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('update'); ?></button>
                        <a href="<?php echo site_url('hr/candidate_login'); ?>" class="btn btn-default"><?php echo _l('back'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
