<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_login extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('hr/candidate_model');
    }

    public function index()
    {
        // Check if user is logged in as staff
        if (is_staff_logged_in()) {
            $staff_id = get_staff_user_id();
            $candidate = $this->candidate_model->get_candidate_by_staff_id($staff_id);
            
            if ($candidate) {
                $data['candidate'] = $candidate;
                $data['title'] = _l('hr_candidate_dashboard');
                $this->load->view('candidates/dashboard', $data);
            } else {
                show_404();
            }
        } else {
            redirect(site_url('authentication'));
        }
    }

    public function profile()
    {
        if (!is_staff_logged_in()) {
            redirect(site_url('authentication'));
        }

        $staff_id = get_staff_user_id();
        $candidate = $this->candidate_model->get_candidate_by_staff_id($staff_id);
        
        if (!$candidate) {
            show_404();
        }

        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $candidateData = [
                'first_name' => trim($post['first_name'] ?? ''),
                'last_name' => trim($post['last_name'] ?? ''),
                'phone' => trim($post['phone'] ?? ''),
                'skills' => trim($post['skills'] ?? ''),
                'education' => trim($post['education'] ?? ''),
                'notes' => trim($post['notes'] ?? ''),
            ];

            $success = $this->candidate_model->update($candidate->id, $candidateData);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('hr_candidate_profile')));
            }
            redirect(site_url('hr/candidate_login/profile'));
        }

        $data['candidate'] = $candidate;
        $data['title'] = _l('hr_candidate_profile');
        $this->load->view('candidates/profile_edit', $data);
    }

    public function assignments()
    {
        if (!is_staff_logged_in()) {
            redirect(site_url('authentication'));
        }

        $staff_id = get_staff_user_id();
        $candidate = $this->candidate_model->get_candidate_by_staff_id($staff_id);
        
        if (!$candidate) {
            show_404();
        }

        $this->load->model('hr/assignment_model');
        $data['assignments'] = $this->assignment_model->get_by_candidate($candidate->id);
        $data['candidate'] = $candidate;
        $data['title'] = _l('hr_my_assignments');
        $this->load->view('candidates/assignments', $data);
    }

    public function submit_assignment($assignment_id)
    {
        if (!is_staff_logged_in()) {
            redirect(site_url('authentication'));
        }

        $staff_id = get_staff_user_id();
        $candidate = $this->candidate_model->get_candidate_by_staff_id($staff_id);
        
        if (!$candidate) {
            show_404();
        }

        if ($this->input->post()) {
            $post = $this->input->post(null, true);
            $assignmentData = [
                'file_path' => trim($post['file_path'] ?? ''),
                'status' => 'submitted',
                'submitted_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ];

            $this->load->model('hr/assignment_model');
            $success = $this->assignment_model->update($assignment_id, $assignmentData);
            if ($success) {
                set_alert('success', _l('hr_assignment_submitted'));
            }
            redirect(site_url('hr/candidate_login/assignments'));
        }

        $this->load->model('hr/assignment_model');
        $data['assignment'] = $this->assignment_model->get($assignment_id);
        if (!$data['assignment'] || $data['assignment']->candidate_id != $candidate->id) {
            show_404();
        }

        $data['candidate'] = $candidate;
        $data['title'] = _l('hr_submit_assignment');
        $this->load->view('candidates/submit_assignment', $data);
    }
}
