<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="horizontal-scrollable-tabs panel-full-width-tabs">
                            <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                            <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                            <div class="horizontal-tabs">
                                <ul class="nav nav-tabs nav-tabs-horizontal" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_candidate_info" aria-controls="tab_candidate_info" role="tab" data-toggle="tab">
                                            <?php echo _l('hr_tab_candidate_info'); ?>
                                        </a>
                                    </li>
                                    <li role="presentation">
                                        <a href="#tab_candidate_docs" aria-controls="tab_candidate_docs" role="tab" data-toggle="tab">
                                            <?php echo _l('hr_tab_candidate_documents'); ?>
                                        </a>
                                    </li>
                                    <li role="presentation">
                                        <a href="#tab_candidate_notes" aria-controls="tab_candidate_notes" role="tab" data-toggle="tab">
                                            <?php echo _l('hr_tab_candidate_notes'); ?>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="tab-content tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_candidate_info">
                                <div class="row">
                                    <div class="col-md-3">
                                        <?php echo render_select('candidate_type', [
                                                ['id' => 'permanent', 'name' => _l('hr_candidate_type_permanent')],
                                                ['id' => 'freelancer', 'name' => _l('hr_candidate_type_freelancer')],
                                                ['id' => 'intern', 'name' => _l('hr_candidate_type_intern')],
                                                ['id' => 'contract', 'name' => _l('hr_candidate_type_contract')],
                                            ], ['id', 'name'], _l('hr_candidate_type'), isset($candidate) ? $candidate->candidate_type : 'permanent'); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_input('first_name', _l('hr_candidate_first_name'), isset($candidate) ? $candidate->first_name : ''); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_input('last_name', _l('hr_candidate_last_name'), isset($candidate) ? $candidate->last_name : ''); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_input('email', _l('hr_candidate_email'), isset($candidate) ? $candidate->email : '', 'email'); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <?php echo render_input('phone', _l('hr_candidate_phone'), isset($candidate) ? $candidate->phone : ''); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_input('position_applied', _l('hr_candidate_position'), isset($candidate) ? $candidate->position_applied : ''); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_input('experience_years', _l('hr_candidate_experience'), isset($candidate) ? $candidate->experience_years : '', 'number'); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <?php echo render_select('status', [
                                                ['id' => 'applied', 'name' => _l('hr_status_applied')],
                                                ['id' => 'shortlisted', 'name' => _l('hr_status_shortlisted')],
                                                ['id' => 'interview', 'name' => _l('hr_status_interview')],
                                                ['id' => 'selected', 'name' => _l('hr_status_selected')],
                                                ['id' => 'rejected', 'name' => _l('hr_status_rejected')],
                                            ], ['id', 'name'], _l('hr_status'), isset($candidate) ? $candidate->status : 'applied'); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php echo render_input('source', _l('hr_candidate_source'), isset($candidate) ? $candidate->source : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_textarea('skills', _l('hr_candidate_skills'), isset($candidate) ? $candidate->skills : '', ['rows' => 2]); ?>
                                    </div>
                                </div>
                            </div>
                            <div role="tabpanel" class="tab-pane" id="tab_candidate_docs">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="resume" class="control-label"><?= _l('resume'); ?></label>
                                            <input type="file" name="resume" class="form-control" id="resume">
                                        </div>
                                        <?php // echo render_input('resume', _l('hr_candidate_resume'), isset($candidate) ? $candidate->resume : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_textarea('education', _l('hr_candidate_education'), isset($candidate) ? $candidate->education : '', ['rows' => 4]); ?>
                                    </div>
                                </div>
                            </div>
                            <div role="tabpanel" class="tab-pane" id="tab_candidate_notes">
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php echo render_textarea('notes', _l('hr_candidate_notes'), isset($candidate) ? $candidate->notes : '', ['rows' => 6]); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
