<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin"><?php echo _l('hr_welcome_candidate'); ?>, <?php echo e($candidate->first_name . ' ' . $candidate->last_name); ?>!</h4>
                                <p class="text-muted"><?php echo e($candidate->position_applied); ?> - <?php echo e(ucfirst($candidate->candidate_type)); ?></p>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo site_url('hr/candidate_login/profile'); ?>" class="btn btn-primary">
                                    <i class="fa-regular fa-user"></i> <?php echo _l('hr_my_profile'); ?>
                                </a>
                                <a href="<?php echo site_url('hr/candidate_login/assignments'); ?>" class="btn btn-info">
                                    <i class="fa-regular fa-tasks"></i> <?php echo _l('hr_my_assignments'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><?php echo _l('hr_candidate_info'); ?></h5>
                                <table class="table table-condensed">
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_type'); ?>:</strong></td>
                                        <td><span class="label label-info"><?php echo e(ucfirst($candidate->candidate_type)); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_status'); ?>:</strong></td>
                                        <td><span class="label label-default"><?php echo e(ucfirst($candidate->status)); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_experience'); ?>:</strong></td>
                                        <td><?php echo e($candidate->experience_years); ?> <?php echo _l('years'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><?php echo _l('hr_quick_actions'); ?></h5>
                                <div class="row">
                                    <div class="col-md-6">
                                        <a href="<?php echo site_url('hr/candidate_login/profile'); ?>" class="btn btn-primary btn-block">
                                            <i class="fa-regular fa-user"></i><br><?php echo _l('hr_update_profile'); ?>
                                        </a>
                                    </div>
                                    <div class="col-md-6">
                                        <a href="<?php echo site_url('hr/candidate_login/assignments'); ?>" class="btn btn-info btn-block">
                                            <i class="fa-regular fa-tasks"></i><br><?php echo _l('hr_view_assignments'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
