<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                                        <div class="row">
                    <div class="col-md-8">
                        <h4 class="no-margin"><?php echo e($candidate->first_name . ' ' . $candidate->last_name); ?></h4>
                        <p class="text-muted"><?php echo e($candidate->position_applied); ?> - <?php echo e(ucfirst($candidate->candidate_type)); ?></p>
                        <?php if ($candidate->staff_firstname) { ?>
                            <p class="text-success"><i class="fa fa-user"></i> <?php echo _l('hr_linked_to_staff'); ?>: <?php echo e($candidate->staff_firstname . ' ' . $candidate->staff_lastname); ?></p>
                        <?php } ?>
                    </div>
                    <div class="col-md-4 text-right">
                        <?php /* if (!$candidate->can_login) { ?>
                            <a href="<?php echo admin_url('hr/candidate/enable_login/' . $candidate->id); ?>" class="btn btn-success">
                                <i class="fa-regular fa-user-plus"></i> <?php echo _l('hr_enable_login'); ?>
                            </a>
                        <?php } else { ?>
                            <a href="<?php echo admin_url('hr/candidate/disable_login/' . $candidate->id); ?>" class="btn btn-warning">
                                <i class="fa-regular fa-user-minus"></i> <?php echo _l('hr_disable_login'); ?>
                            </a>
                        <?php } */ ?>
                        <a href="<?php echo admin_url('hr/candidate/edit/' . $candidate->id); ?>" class="btn btn-primary">
                            <i class="fa-regular fa-pen-to-square"></i> <?php echo _l('edit'); ?>
                        </a>
                        <a href="<?php echo admin_url('hr/candidate'); ?>" class="btn btn-default">
                            <?php echo _l('Back'); ?>
                        </a>
                    </div>
                </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><?php echo _l('hr_candidate_info'); ?></h5>
                                <table class="table table-condensed">
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_type'); ?>:</strong></td>
                                        <td><span class="label label-info"><?php echo e(ucfirst($candidate->candidate_type)); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_email'); ?>:</strong></td>
                                        <td><?php echo e($candidate->email); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_phone'); ?>:</strong></td>
                                        <td><?php echo e($candidate->phone); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_status'); ?>:</strong></td>
                                        <td><span class="label label-default"><?php echo e(ucfirst($candidate->status)); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_experience'); ?>:</strong></td>
                                        <td><?php echo e($candidate->experience_years); ?> <?php echo _l('years'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_candidate_source'); ?>:</strong></td>
                                        <td><?php echo e($candidate->source); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo _l('hr_login_status'); ?>:</strong></td>
                                        <td>
                                            <?php if ($candidate->can_login) { ?>
                                                <span class="label label-success"><?php echo _l('hr_can_login'); ?></span>
                                                <?php if ($candidate->login_enabled_at) { ?>
                                                    <br><small class="text-muted"><?php echo _l('hr_enabled_at'); ?>: <?php echo e(_d($candidate->login_enabled_at)); ?></small>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <span class="label label-default"><?php echo _l('hr_cannot_login'); ?></span>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><?php echo _l('hr_candidate_skills'); ?></h5>
                                <p><?php echo e($candidate->skills); ?></p>
                                
                                <h5><?php echo _l('hr_candidate_education'); ?></h5>
                                <p><?php echo e($candidate->education); ?></p>
                                
                                <h5><?php echo _l('hr_candidate_notes'); ?></h5>
                                <p><?php echo e($candidate->notes); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="panel_s">
                            <div class="panel-heading">
                                <h5><?php echo _l('hr_contracts'); ?></h5>
                            </div>
                            <div class="panel-body">
                                <?php if (!empty($contracts)) { ?>
                                    <?php foreach ($contracts as $contract) { ?>
                                        <div class="media">
                                            <div class="media-body">
                                                <h6 class="media-heading"><?php echo e($contract['title']); ?></h6>
                                                <small class="text-muted"><?php echo e(ucfirst($contract['status'])); ?></small>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <p class="text-muted"><?php echo _l('no_contracts_found'); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel_s">
                            <div class="panel-heading">
                                <h5><?php echo _l('hr_assignments'); ?></h5>
                            </div>
                            <div class="panel-body">
                                <?php if (!empty($assignments)) { ?>
                                    <?php foreach ($assignments as $assignment) { ?>
                                        <div class="media">
                                            <div class="media-body">
                                                <h6 class="media-heading"><?php echo e($assignment['title']); ?></h6>
                                                <small class="text-muted"><?php echo e(ucfirst($assignment['status'])); ?></small>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <p class="text-muted"><?php echo _l('no_assignments_found'); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel_s">
                            <div class="panel-heading">
                                <h5><?php echo _l('hr_certifications'); ?></h5>
                            </div>
                            <div class="panel-body">
                                <?php if (!empty($certifications)) { ?>
                                    <?php foreach ($certifications as $certification) { ?>
                                        <div class="media">
                                            <div class="media-body">
                                                <h6 class="media-heading"><?php echo e($certification['certificate_type']); ?></h6>
                                                <small class="text-muted"><?php echo e(ucfirst($certification['status'])); ?></small>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <p class="text-muted"><?php echo _l('no_certifications_found'); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
