<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_select('candidate_id', array_map(function($candidate){return ['id'=>$candidate['id'],'name'=>$candidate['first_name'].' '.$candidate['last_name']];}, $candidates), ['id','name'], _l('hr_candidate'), isset($certification) ? $certification->candidate_id : ''); ?>
                            </div>
                            <?php /*
                            <div class="col-md-6">
                                <?php echo render_input('certificate_type', _l('hr_certificate_type'), isset($certification) ? $certification->certificate_type : ''); ?>
                            </div>
                            */ ?>
                            <div class="col-md-6">
                                <?php echo render_input('certificate_number', _l('hr_certificate_number'), isset($certification) ? $certification->certificate_number : ''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_date_input('issued_at', _l('hr_issued_at'), isset($certification) ? $certification->issued_at : ''); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_date_input('expires_at', _l('hr_expires_at'), isset($certification) ? $certification->expires_at : ''); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="file_path" class="control-label"><?= _l('Certificate'); ?></label>
                                    <input type="file" name="file_path" class="form-control" id="file_path">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_select('status', [
                                        ['id' => 'draft', 'name' => _l('hr_status_draft')],
                                        ['id' => 'issued', 'name' => _l('hr_status_issued')],
                                        ['id' => 'expired', 'name' => _l('hr_status_expired')],
                                        ['id' => 'revoked', 'name' => _l('hr_status_revoked')],
                                    ], ['id', 'name'], _l('hr_status'), isset($certification) ? $certification->status : 'draft'); ?>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/certification'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
