<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <?php echo form_open_multipart(); ?>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="horizontal-scrollable-tabs panel-full-width-tabs">
                            <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                            <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                            <div class="horizontal-tabs">
                                <ul class="nav nav-tabs nav-tabs-horizontal" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_contract_info" aria-controls="tab_contract_info" role="tab" data-toggle="tab">
                                            <?php echo _l('hr_tab_contract_info'); ?>
                                        </a>
                                    </li>
                                    <!-- <li role="presentation">
                                        <a href="#tab_contract_terms" aria-controls="tab_contract_terms" role="tab" data-toggle="tab">
                                            <?php // echo _l('hr_tab_contract_terms'); ?>
                                        </a>
                                    </li> -->
                                </ul>
                            </div>
                        </div>
                        <div class="tab-content tw-mt-3">
                            <div role="tabpanel" class="tab-pane active" id="tab_contract_info">
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php echo render_input('title', _l('hr_contract_title'), isset($contract) ? $contract->title : ''); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php echo render_select('candidate_id', array_map(function($id,$name){return ['id'=>$id,'name'=>$name];}, array_keys($candidates_kv), $candidates_kv), ['id','name'], _l('hr_contract_candidate'), isset($contract) ? $contract->candidate_id : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('contract_type', [
                                                ['id' => 'employment', 'name' => _l('hr_contract_type_employment')],
                                                ['id' => 'contractor', 'name' => _l('hr_contract_type_contractor')],
                                                ['id' => 'internship', 'name' => _l('hr_contract_type_internship')],
                                            ], ['id', 'name'], _l('hr_contract_type'), isset($contract) ? $contract->contract_type : 'employment'); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_date_input('start_date', _l('hr_contract_start_date'), isset($contract) ? $contract->start_date : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_date_input('end_date', _l('hr_contract_end_date'), isset($contract) ? $contract->end_date : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_input('salary', _l('hr_contract_salary'), isset($contract) ? $contract->salary : '', 'number', ['step' => '0.01']); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_input('currency', _l('hr_contract_currency'), isset($contract) ? $contract->currency : ''); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php echo render_select('status', [
                                                ['id' => 'draft', 'name' => _l('hr_status_draft')],
                                                ['id' => 'processing', 'name' => _l('hr_status_processing')],
                                                ['id' => 'signed', 'name' => _l('hr_status_signed')],
                                                ['id' => 'expired', 'name' => _l('hr_status_expired')],
                                            ], ['id', 'name'], _l('hr_status'), isset($contract) ? $contract->status : 'draft'); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="file_path" class="control-label"><?= _l('hr_contract_file'); ?></label>
                                            <input type="file" name="file_path" class="form-control" id="file_path">
                                        </div>
                                        <?php // echo render_input('file_path', _l('hr_contract_file'), isset($contract) ? $contract->file_path : ''); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer text-right">
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <a href="<?php echo admin_url('hr/contract'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
