<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
/* Modal Background with blur effect */
.custom-modal {
    display: none;
    position: fixed;
    z-index: 9999;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    backdrop-filter: blur(6px); /* modern glass effect */
    background: rgba(0,0,0,0.5);
    animation: fadeIn 0.3s;
}

/* Modal Box */
.custom-modal-content {
    background: linear-gradient(145deg, #ffffff, #f0f0f5);
    margin: 6% auto;
    padding: 30px 25px;
    width: 420px;
    border-radius: 16px;
    box-shadow: 0 20px 50px rgba(0,0,0,0.3);
    position: relative;
    animation: slideDown 0.4s ease;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    transition: transform 0.3s ease;
}

/* Hover effect */
.custom-modal-content:hover {
    transform: translateY(-5px);
}

/* Close Button */
.close-btn {
    position: absolute;
    top: 12px;
    right: 18px;
    font-size: 28px;
    font-weight: bold;
    color: #555;
    cursor: pointer;
    transition: all 0.2s;
}
.close-btn:hover {
    color: #e74c3c;
    transform: rotate(90deg);
}

/* Modal Title */
.modal-title {
    margin-bottom: 25px;
    text-align: center;
    font-weight: 600;
    color: #333;
    letter-spacing: 0.5px;
}

/* Form Inputs */
.form-label {
    display: block;
    margin-top: 12px;
    margin-bottom: 6px;
    font-weight: 500;
    color: #555;
}

.form-input, .form-select {
    width: 100%;
    padding: 12px 15px;
    border-radius: 10px;
    border: 1px solid #ccc;
    margin-bottom: 18px;
    font-size: 14px;
    outline: none;
    transition: all 0.3s ease;
}
.form-input:focus, .form-select:focus {
    border-color: #007bff;
    box-shadow: 0 0 10px rgba(0,123,255,0.2);
}

/* Buttons */
.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 12px;
    margin-top: 15px;
}

.btn-save {
    background: linear-gradient(90deg, #007bff, #0056b3);
    color: #fff;
    padding: 10px 25px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-weight: 500;
    transition: all 0.2s ease;
}
.btn-save:hover {
    transform: scale(1.05);
    box-shadow: 0 8px 20px rgba(0,123,255,0.4);
}

.btn-cancel {
    background: #f0f0f0;
    color: #555;
    padding: 10px 25px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-weight: 500;
    transition: all 0.2s ease;
}
.btn-cancel:hover {
    background: #e0e0e0;
}

/* Trigger Button */
.btn-custom {
    background: linear-gradient(90deg, #007bff, #0056b3);
    color: #fff;
    padding: 12px 25px;
    border: none;
    border-radius: 12px;
    cursor: pointer;
    font-weight: 500;
    transition: all 0.2s ease;
}
.btn-custom:hover {
    transform: translateY(-2px) scale(1.03);
    box-shadow: 0 10px 25px rgba(0,123,255,0.4);
}

/* Animations */
@keyframes fadeIn {
    from {opacity: 0;}
    to {opacity: 1;}
}

@keyframes slideDown {
    from {transform: translateY(-50px); opacity: 0;}
    to {transform: translateY(0); opacity: 1;}
}

#dateWrapper {
    transition: all 0.3s ease;
}


.btn-no-style {
    background: none;
    border: none;
    color: rgb(55 65 81); /* or your preferred color */
    font-size: 11px;
    cursor: pointer;
    padding: 0; /* remove default button padding */
}
.btn-no-style:focus {
    outline: none; /* remove the blue border when clicked */
}

</style>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <!-- Filters -->
                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <?php echo form_open(admin_url('hr/contract'), 'method="get"'); ?>
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo render_select('status', [["key" => '', 'value' => 'All'],
                                        ["key" => 'draft', 'value' => 'Draft'],
                                        ["key" => 'open', 'value' => 'Open'],
                                        ["key" => 'processing', 'value' => 'Processing'],
                                        ["key" => 'approved', 'value' => 'Approved'],
                                        ["key" => 'rejected', 'value' => 'Rejected'],
                                        ["key" => 'expired', 'value' => 'Expired']], ['key', 'value'], '', $filters['status'] ?? ''); ?>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary btn-block"><?php echo _l('filter'); ?></button>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-contracts">
                                <thead>
                                <tr>
                                    <th><?php echo _l('hr_contract_title'); ?></th>
                                    <th><?php echo _l('hr_contract_candidate'); ?></th>
                                    <th><?php echo _l('Status'); ?></th>
                                    <th><?php echo _l('Created Date'); ?></th>
                                    <th><?php echo _l('Creation By'); ?></th>
                                    <th><?php echo _l('Contact'); ?></th>
                                    <th><?php echo _l('Email'); ?></th>
                                    <th><?php echo _l('Valid Through'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; ?>
                                <?php foreach ($contracts as $row) { ?>
                                    <tr>
                                        <td>
                                            <?= $row['title'] ?>
                                            <div class="row-options">
                                                <button onclick="openPopup(<?= $row['id'] ?>)" class="btn-no-style">
                                                    Update Status/Date
                                                </button>
                                            </div>
                                        </td>
                                        <td><?php echo e($row['first_name'] . ' ' . $row['last_name'] ?? 'N/A'); ?></td>
                                        <td>
                                            <?php
                                                $badges = [
                                                    'draft' => 'warning',     // yellow
                                                    'open' => 'info',         // light blue
                                                    'processing' => 'primary',// blue
                                                    'approved' => 'success',  // green
                                                    'rejected' => 'danger',   // red
                                                    'expired' => 'secondary', // gray
                                                ];

                                                $status = strtolower($row['status']);
                                                $badgeClass = isset($badges[$status]) ? $badges[$status] : 'dark';
                                            ?>
                                            <span class="badge bg-<?php echo $badgeClass; ?>">
                                                <?php echo ucfirst($row['status']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo _d($row['created_at']); ?></td>
                                        <td><?php echo e(ucfirst($row['created_by_name'])); ?></td>
                                        <td><?php echo e($row['phone']); ?></td>
                                        <td><?php echo e($row['email']); ?></td>
                                        <td><?php echo _d($row['valid_date']); ?></td>
                                    </tr>
                                <?php $i++; ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="statusModal" class="custom-modal">
                    <div class="custom-modal-content">
                        <span class="close-btn" onclick="closePopup()">&times;</span>
                        <h3 class="modal-title">Update Status/Date</h3>
                        <form id="statusForm">
                            <input type="hidden" name="id" id="recordId">
    <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" id="csrf_token" value="<?= $this->security->get_csrf_hash(); ?>">

                            <label class="form-label">Status</label>
                            <select name="status" id="status" class="form-select">
                                <option value="draft">Draft</option>
                                <option value="open">Open</option>
                                <option value="processing">Processing</option>
                                <option value="approved">Approved</option>
                                <option value="rejected">Rejected</option>
                                <option value="expired">Expired</option>
                            </select>

                            <div>
                                <label class="form-label">Date</label>
                                <input type="date" name="date" id="date" class="form-input">
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn-cancel" onclick="closePopup()">Cancel</button>
                                <button type="button" class="btn-save" onclick="submitForm()">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php init_tail(); ?>

<script>
function openPopup(id) {
    document.getElementById('recordId').value = id;

    fetch(`<?= admin_url('hr/contract/get_status/') ?>${id}`)
        .then(res => res.json())
        .then(data => {
            console.log('Fetched status:', data.status); // <-- check what we get

            const statusSelect = document.getElementById('status');
            statusSelect.value = data.status.trim().toLowerCase(); // normalize

            const dateWrapper = document.getElementById('dateWrapper');
            const dateInput = document.getElementById('date');
            dateInput.value = data.date || '';

            // Show/hide date based on status
            const normalizedStatus = data.status.trim().toLowerCase();
            if(normalizedStatus === 'draft' || normalizedStatus === 'expired'){
                dateWrapper.style.display = 'block';
            } else {
                dateWrapper.style.display = 'none';
            }
        });

    document.getElementById('statusModal').style.display = 'block';

    // Attach listener once
    const statusSelect = document.getElementById('status');
    if(!statusSelect.dataset.listenerAttached){
        statusSelect.addEventListener('change', function() {
            const selected = this.value.trim().toLowerCase();
            const dateWrapper = document.getElementById('dateWrapper');
            dateWrapper.style.display = (selected === 'draft' || selected === 'expired') ? 'block' : 'none';
        });
        statusSelect.dataset.listenerAttached = true;
    }
}

function closePopup() {
    document.getElementById('statusModal').style.display = 'none';
}

function submitForm() {
    const form = document.getElementById('statusForm');
    const formData = new FormData(form);

    fetch('<?= admin_url('hr/contract/update_status') ?>', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            closePopup();
            // alert('Updated successfully!');
            location.reload();
        } else {
            alert('Error updating!');
        }
    })
    .catch(err => {
        console.error('AJAX error:', err);
        alert('Something went wrong!');
    });
}

// Optional: close modal if click outside content
window.onclick = function(event) {
    const modal = document.getElementById('statusModal');
    if (event.target == modal) {
        modal.style.display = "none";
    }
}

</script>
