<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Virtual_office extends AdminController {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('virtual_office/Virtual_office_model');
	}

	public function index()
	{
		// Load module view from module_views_path to avoid theme path issues
		$this->load->view('virtual_office/office_home');
	}

	public function department($dept = '')
	{
		$allowed = [
			'technology' => 'department_technology',
			'hr' => 'department_hr',
			'admin' => 'department_admin',
			'accounting_finance' => 'department_accounting_finance',
			'sales_marketing' => 'department_sales_marketing',
			'meeting_room' => 'department_meeting_room',
		];

		$dept = strtolower(trim($dept));
		if (!array_key_exists($dept, $allowed)) {
			show_404();
		}

		$data = [];
		$data['department'] = $dept;
		$data['staff'] = $this->Virtual_office_model->get_department_staff($dept);
		$this->load->view(module_views_path('virtual_office', $allowed[$dept]), $data);
	}

	public function timesheet()
	{
		$data = [];
		$data['timesheet'] = $this->Virtual_office_model->get_timesheet(get_staff_user_id());
		$this->load->view('virtual_office/timesheet', $data);
	}

	public function get_timesheet_calendar_data()
	{
		$start = $this->input->get('start');
		$end = $this->input->get('end');
		
		$timesheet_data = $this->Virtual_office_model->get_timesheet_calendar_data(
			get_staff_user_id(),
			$start,
			$end
		);
		
		echo json_encode($timesheet_data);
	}

	public function day_report()
	{
		$data = [];
		$data['title'] = "Log of the Day";
		$data['timelogs'] = [
			['signintime' => '09:00 Hrs',
			'signouttime' => '12:00 Hrs',
			'internet_breakage' => '', ],
			['signintime' => '12:30 Hrs',
			'signouttime' => '',
			'internet_breakage' => '01:00 Hrs', ]

		];
		$this->load->view('virtual_office/day_report', $data);
	}

	public function meetings()
	{
		$data = [];
		$data['title'] = "Meeting Room";
		$this->load->view('virtual_office/meetings', $data);
		
	}
}


