<?php

defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: Virtual Office
Description: Virtual Office module
Version: 1.0.0
Requires at least: 2.3.*
*/

define('VIRTUAL_OFFICE_MODULE_NAME', 'Virtual Office');
define('VIRTUAL_OFFICE_ASSETS_PATH', 'modules/virtual_office/assets');

hooks()->add_action('app_admin_head', 'virtual_office_styles');
function virtual_office_styles()
{
    echo '<link href="' . module_dir_url('virtual_office', 'assets/css/virtual_office.css') . '" rel="stylesheet" type="text/css">';
}

/**
 * Register activation module hook
 */
register_activation_hook(VIRTUAL_OFFICE_MODULE_NAME, 'virtual_office_module_activation_hook');
function virtual_office_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(VIRTUAL_OFFICE_MODULE_NAME, [VIRTUAL_OFFICE_MODULE_NAME]);

/**
 * Basic admin menu
 */
hooks()->add_action('admin_init', 'virtual_office_module_init_menu_items');
function virtual_office_module_init_menu_items()
{
    $CI = &get_instance();
    $CI->app_menu->add_sidebar_menu_item('virtual_office-module', [
        'name'     => _l('Virtual Office'),
        'href'     => admin_url('virtual_office/virtual_office'),
        'position' => 50,
        'icon'     => 'fa fa-users',
    ]);

    $CI->app_menu->add_sidebar_children_item('virtual_office-module', [
        'slug'     => 'virtual_office-dashboard',
        'name'     => _l('Meetings Room'),
        'href'     => admin_url('virtual_office/meetings'),
        'position' => 1,
    ]);

    $CI->app_menu->add_sidebar_children_item('virtual_office-module', [
        'slug'     => 'virtual_office-timesheet',
        'name'     => _l('Timesheet'),
        'href'     => admin_url('virtual_office/virtual_office/timesheet'),
        'position' => 2,
    ]);
}
