<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * HR Module Install Script
 * Creates database tables for candidates and contracts
 */

$CI = &get_instance();

// Create candidates table
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'hr_candidates` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `staff_id` INT NULL,
  `candidate_type` ENUM("permanent", "freelancer", "intern", "contract") NOT NULL DEFAULT "permanent",
  `first_name` VARCHAR(191) NOT NULL,
  `last_name` VARCHAR(191) NOT NULL,
  `email` VARCHAR(191) NULL UNIQUE,
  `phone` VARCHAR(50) NULL,
  `position_applied` VARCHAR(191) NULL,
  `resume` TEXT NULL,
  `skills` TEXT NULL,
  `experience_years` INT NULL,
  `education` TEXT NULL,
  `status` ENUM("applied", "shortlisted", "interview", "selected", "rejected", "hired") NOT NULL DEFAULT "applied",
  `source` VARCHAR(50) NULL,
  `notes` TEXT NULL,
  `can_login` TINYINT(1) NOT NULL DEFAULT 0,
  `login_enabled_at` DATETIME NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `created_by` INT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id_idx` (`staff_id`),
  KEY `candidate_type_idx` (`candidate_type`),
  KEY `status_idx` (`status`),
  KEY `email_idx` (`email`),
  KEY `can_login_idx` (`can_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8');

// Create contracts table
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'hr_contracts` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `candidate_id` INT UNSIGNED NULL,
  `title` VARCHAR(191) NOT NULL,
  `contract_type` VARCHAR(50) NOT NULL DEFAULT "employment",
  `start_date` DATE NULL,
  `end_date` DATE NULL,
  `salary` DECIMAL(15,2) NULL,
  `currency` VARCHAR(10) NULL,
  `status` ENUM("draft", "processing", "signed", "expired") NOT NULL DEFAULT "draft",
  `file_path` VARCHAR(255) NULL,
  `signed_at` DATETIME NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  KEY `candidate_id_idx` (`candidate_id`),
  KEY `status_idx` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8');

// Create assignments table
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'hr_assignments` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `candidate_id` INT UNSIGNED NOT NULL,
  `title` VARCHAR(191) NOT NULL,
  `description` TEXT NULL,
  `file_path` VARCHAR(255) NULL,
  `status` ENUM("pending", "submitted", "approved", "rejected") NOT NULL DEFAULT "pending",
  `submitted_at` DATETIME NULL,
  `approved_at` DATETIME NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  KEY `candidate_id_idx` (`candidate_id`),
  KEY `status_idx` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8');

// Create certifications table
$CI->db->query('CREATE TABLE IF NOT EXISTS `'.db_prefix().'hr_certifications` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `candidate_id` INT UNSIGNED NOT NULL,
  `certificate_type` VARCHAR(191) NOT NULL,
  `certificate_number` VARCHAR(100) NULL,
  `issued_at` DATETIME NULL,
  `expires_at` DATETIME NULL,
  `file_path` VARCHAR(255) NULL,
  `status` ENUM("draft", "issued", "expired", "revoked") NOT NULL DEFAULT "draft",
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  KEY `candidate_id_idx` (`candidate_id`),
  KEY `status_idx` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8');

// Try to add foreign keys (ignore errors if already exists or not supported)
try {
    $CI->db->query('ALTER TABLE `'.db_prefix().'hr_candidates` 
        ADD CONSTRAINT `fk_hr_candidates_staff` FOREIGN KEY (`staff_id`) 
        REFERENCES `'.db_prefix().'staff`(`staffid`) 
        ON UPDATE CASCADE ON DELETE SET NULL');
} catch (Exception $e) {
    // ignore
}

try {
    $CI->db->query('ALTER TABLE `'.db_prefix().'hr_contracts` 
        ADD CONSTRAINT `fk_hr_contracts_candidate` FOREIGN KEY (`candidate_id`) 
        REFERENCES `'.db_prefix().'hr_candidates`(`id`) 
        ON UPDATE CASCADE ON DELETE SET NULL');
} catch (Exception $e) {
    // ignore
}

try {
    $CI->db->query('ALTER TABLE `'.db_prefix().'hr_assignments` 
        ADD CONSTRAINT `fk_hr_assignments_candidate` FOREIGN KEY (`candidate_id`) 
        REFERENCES `'.db_prefix().'hr_candidates`(`id`) 
        ON UPDATE CASCADE ON DELETE CASCADE');
} catch (Exception $e) {
    // ignore
}

try {
    $CI->db->query('ALTER TABLE `'.db_prefix().'hr_certifications` 
        ADD CONSTRAINT `fk_hr_certifications_candidate` FOREIGN KEY (`candidate_id`) 
        REFERENCES `'.db_prefix().'hr_candidates`(`id`) 
        ON UPDATE CASCADE ON DELETE CASCADE');
} catch (Exception $e) {
    // ignore
}
