<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <!-- Filters -->
                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <?php echo form_open(admin_url('hr/contract'), 'method="get"'); ?>
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo render_select('status', [["key" => '', 'value' => 'All'],
                                        ["key" => 'draft', 'value' => 'Draft'],
                                        ["key" => 'open', 'value' => 'Open'],
                                        ["key" => 'processing', 'value' => 'Processing'],
                                        ["key" => 'approved', 'value' => 'Approved'],
                                        ["key" => 'rejected', 'value' => 'Rejected'],
                                        ["key" => 'expired', 'value' => 'Expired']], ['key', 'value'], '', $filters['status'] ?? ''); ?>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary btn-block"><?php echo _l('filter'); ?></button>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-contracts">
                                <thead>
                                <tr>
                                    <th><?php echo _l('hr_contract_title'); ?></th>
                                    <th><?php echo _l('hr_contract_candidate'); ?></th>
                                    <th><?php echo _l('Status'); ?></th>
                                    <th><?php echo _l('Created Date'); ?></th>
                                    <th><?php echo _l('Creation By'); ?></th>
                                    <th><?php echo _l('Contact'); ?></th>
                                    <th><?php echo _l('Email'); ?></th>
                                    <th><?php echo _l('Valid Through'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; ?>
                                <?php foreach ($contracts as $row) { ?>
                                    <tr>
                                        <td><?php echo e($row['title']); ?></td>
                                        <td><?php echo e($row['first_name'] . ' ' . $row['last_name'] ?? 'N/A'); ?></td>
                                        <td><?php echo e($row['status']); ?></td>
                                        <td><?php echo _d($row['created_at']); ?></td>
                                        <td><?php echo e(ucfirst($row['created_by_name'])); ?></td>
                                        <td><?php echo e($row['phone']); ?></td>
                                        <td><?php echo e($row['email']); ?></td>
                                        <td><?php echo _d($row['valid_date']); ?></td>
                                    </tr>
                                <?php $i++; ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
