<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Mpdf\Mpdf;
class Candidate_client extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('email'); // Perfex uses PHPMailer wrapper
        $this->load->model('candidate_model'); // ← load your model
        $this->load->model('candidate_client_model'); // Custom model
        $this->load->model('emails_model'); // for sending emails
        $this->load->model('contracts_model'); // ← load your model

    }

    // public function index($token = '')
    // {
    //     $data['title'] = _l('Candidate Login');

    //     if ($token != '') {
    //         // Fetch candidate using token
    //         $candidate = $this->candidate_model->get_by_token($token);
    //         // var_dump($candidate); die;

    //         if (!$candidate) {
    //             set_alert('danger', 'Invalid or expired verification link.');
    //             redirect(site_url('candidate_client'));
    //         }

    //         $data['candidate'] = $candidate;
    //     } else {
    //         $data['candidate'] = null; // Or handle as needed
    //     }

    //     $this->data($data);
    //     $this->view('hr/candidate_client/index');
    //     $this->layout();
    // }
    // // Step 1: Send OTP using token
    // public function send_otp($token = '')
    // {
    //     if ($token == '') {
    //         set_alert('danger', 'Token is required.');
    //         redirect(site_url('candidate_client'));
    //     }

    //     // Fetch candidate using token
    //     $candidate = $this->candidate_model->get_by_token($token);

    //     if (!$candidate) {
    //         set_alert('danger', 'Invalid or expired token.');
    //         redirect(site_url('candidate_client'));
    //     }

    //     $email = $candidate->email;

    //     // Generate OTP
    //     $otp = rand(100000, 999999);

    //     // Save OTP to DB
    //     $this->candidate_client_model->save_otp($email, $otp);

    //     // Send OTP via email
    //     $subject = 'Your Candidate OTP Code';
    //     $message = 'Your OTP is: <b>' . $otp . '</b>';
    //     $this->emails_model->send_simple_email($email, $subject, $message);

    //     set_alert('success', 'OTP has been sent to your email.');
    //     redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
    // }



    // Step 1: Send OTP
    // public function send_otp()
    // {
    //     $email = $this->input->post('email');

    //     if (!$email) {
    //         set_alert('danger', 'Email is required');
    //         redirect(site_url('candidate_client'));
    //     }

    //     // Generate OTP
    //     $otp = rand(100000, 999999);

    //     // Save OTP to DB
    //     $this->candidate_client_model->save_otp($email, $otp);

    //     // Send OTP via email
    //     $subject = 'Your Candidate OTP Code';
    //     $message = 'Your OTP is: <b>' . $otp . '</b>';

    //     $this->emails_model->send_simple_email($email, $subject, $message);

    //     set_alert('success', 'OTP has been sent to your email.');
    //     redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
    // }

    public function index($token = '')
    {
        $data['title'] = _l('Candidate Login');
        $data['candidate'] = null;

        if ($token != '') {
            // Fetch candidate using token
            $candidate = $this->candidate_model->get_by_token($token);

            if (!$candidate) {
                set_alert('danger', 'Invalid or expired verification link.');
            } else {
                $data['candidate'] = $candidate;

                // Generate OTP
                $email = $candidate->email;
                $otp = rand(100000, 999999);

                // Save OTP to DB
                $this->candidate_client_model->save_otp($email, $otp);

                // Send OTP via email
                $subject = 'Your Candidate OTP Code';
                $message = 'Your OTP is: <b>' . $otp . '</b>';
                $this->emails_model->send_simple_email($email, $subject, $message);

                set_alert('success', 'OTP has been sent to your email.');
            }
        }

        // Keep the token in data to pass it to view
        $data['token'] = $token;

        // Render the index page
        $this->data($data);
        $this->view('hr/candidate_client/index');
        $this->layout();
    }


    // Step 2: Verify OTP
    public function verify()
    {
        $email = $this->input->get('email');
        $data['title'] = _l('Verify OTP');
        $data['email'] = $email;

        $this->data($data);
        $this->view('hr/candidate_client/verify');
        $this->layout();
    }

    public function check_otp()
    {
        $email = $this->input->post('email');
        $otp_array = $this->input->post('otp'); 
        $otp = implode('', $otp_array);         

        if ($this->candidate_client_model->verify_otp($email, $otp)) {
            // fetch candidate ID using email
            $candidate = $this->candidate_client_model->get_by_email($email); // create this if needed
            $candidate_id = $candidate ? $candidate->id : null;

            if ($candidate_id) {
                set_alert('success', 'OTP Verified Successfully');
                redirect(site_url('hr/candidate_client/contracts_list/'.$candidate_id));
            } else {
                set_alert('danger', 'Candidate not found');
                redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
            }
        } else {
            set_alert('danger', 'Invalid OTP');
            redirect(site_url('candidate_client/verify?email=' . urlencode($email)));
        }
    }


    // Candidate Dashboard
    public function dashboard()
    {
        $data['title'] = _l('Candidate Dashboard');
        $this->data($data);
        $this->view('hr/candidate_client/dashboard');
        $this->layout();
    }

    public function contracts_list($candidate_id = null)
    {

        if (!$candidate_id) {
            // Example: pull from logged-in candidate session/token
            $candidate_id = get_client_user_id(); 
            // or however you’re tracking candidates
        }

        $data['title'] = _l('Contracts List');
        $data['contracts'] = $this->candidate_client_model->get_candidate_contracts($candidate_id);
        // var_dump($data['contracts']); die;

        $this->data($data);
        $this->view('hr/candidate_client/contracts_list');
        $this->layout();
    }

    public function view_contract_pdf($contract_id)
    {
        $this->load->model('candidate_client_model');
        $contract = $this->candidate_client_model->get_contract_by_id($contract_id);

        if (!$contract) {
            show_error('Contract not found');
        }

        // Fetch the candidate contract record
        $this->load->model('Candidate_contract_model', 'contract_model');
        $candidate_contract = $this->contract_model->get_by_contract_id($contract_id); // create this method if not exists

        // Decode intern info JSON
        $intern_info = [];
        if (!empty($candidate_contract->intern_info)) {
            $intern_info = json_decode($candidate_contract->intern_info, true);
        }

        // var_dump($intern_info); die;
        $company_info = $candidate_contract->company_info ?? '';

        // Load PDF helper and library
        $this->load->helper('pdf');
        $this->load->library('pdf');

        $pdf = new Pdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf->SetTitle('Contract - ' . $contract->id);
        $pdf->SetAuthor(get_option('companyname'));
        $pdf->SetMargins(15, 20, 15);
        $pdf->AddPage();

        // Build HTML with actual data
        $html  = '<h2 style="text-align:center;">' . $contract->title . '</h2>';
        $html .= '<p><strong>Created At:</strong> ' . _dt($contract->created_at) . '</p>';
        $html .= '<hr>';
        $html .= '<div>' . $contract->details . '</div>';

        $html .= '<table border="0" cellpadding="5" cellspacing="0" width="100%">
            <tr>
                <td width="50%" valign="top">
                    <strong>INTERN</strong><br><br>
                    <table cellpadding="3" cellspacing="0" border="0">';
        
                    // Intern info dynamically
                    $intern_fields = ['intern_name' => 'Name', 'job_role' => 'Job Role', 'date' => 'Date', 'signature' => 'Signature'];
                    foreach ($intern_fields as $key => $label) {
                        $value = $intern_info[$key] ?? '________________';
                        $html .= '<tr>
                                    <td>' . $label . ':</td>
                                    <td>' . $value . '</td>
                                </tr>';
                    }

                    $html .= '</table>
                            </td>

                            <td width="50%" valign="top">
                                <strong>COMPANY DETAILS</strong><br><br>';
        
        $html .= nl2br($company_info ?: '________________'); // convert line breaks
        $html .= '
                </td>
            </tr>
        </table>
        <br /><hr width="100%" />';

        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->Output(slug_it($contract->title) . '.pdf', 'I');
    }

    public function sign_contract($contract_id = null)
    {
        if (!$contract_id) {
            set_alert('danger', 'Invalid Contract');
            redirect(site_url('hr/candidate_client/contracts_list'));
        }

        $this->load->model('candidate_client_model');
        $this->candidate_client_model->update_candidate_status($contract_id, 'open');

        $contract = $this->candidate_client_model->get_contract_by_id($contract_id);

        if (!$contract) {
            set_alert('danger', 'Contract not found');
            redirect(site_url('hr/candidate_client/contracts_list'));
        }

        $data['title'] = _l('Sign Contract');
        $data['contract'] = $contract;

        // URL to render HTML/PDF in iframe
        $data['pdf_url'] = site_url('hr/candidate_client/view_contract_pdf/' . $contract_id);

        $this->data($data);
        $this->view('hr/candidate_client/sign_contract');
        $this->layout();
    }

    public function thank_you($contract_id = null) {
        $data['title'] = _l('Thank You');
        $contract = $this->candidate_client_model->get_candidate_by_contract_by_id($contract_id);
        $data['email'] = $contract ? $contract->email : '';
        $this->data($data);
        $this->view('hr/candidate_client/thank_you');
        $this->layout();
    }

    public function view_contract($filename = '')
    {
        $path = FCPATH . 'uploads/contracts/' . $filename;

        if (file_exists($path)) {
            header('Content-Type: application/pdf');
            header('Content-Disposition: inline; filename="' . $filename . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            exit;
        } else {
            show_404();
        }
    }

    public function save_signature()
    {
        $contract_id = $this->input->post('contract_id');

        if (!$contract_id) {
            echo json_encode([
                'success'  => false,
                'error'    => 'Invalid contract ID',
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
            return;
        }

        // Common path for signature images
        $upload_dir = FCPATH . 'uploads/hr/contract_signatures/';
        $upload_url = 'uploads/hr/contract_signatures/';

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        $signature_file_path = '';
        if ($this->input->post('type') == 'draw') {
            $dataURL = $_POST['signature'];

            // Detect and remove base64 prefix dynamically
            if (strpos($dataURL, 'base64,') !== false) {
                $dataURL = explode('base64,', $dataURL)[1];
            }

            // Fix spaces
            $dataURL = str_replace(' ', '+', $dataURL);

            // Decode the base64 string
            $image_data = base64_decode($dataURL);

            if ($image_data === false) {
                return false; // Invalid base64
            }

            $file_name = 'signature_' . $contract_id . '_' . time() . '.png';
            $signature_file_path = $upload_dir . $file_name;
            file_put_contents($signature_file_path, $image_data);
            $signature_file_path = $upload_url . $file_name;
        }elseif ($this->input->post('type') == 'type') {
            $text = $this->input->post('signature');

            $im = imagecreatetruecolor(500, 150);
            $bg = imagecolorallocate($im, 255, 255, 255);
            $color = imagecolorallocate($im, 0, 0, 0);
            imagefilledrectangle($im, 0, 0, 500, 150, $bg);

            $font = FCPATH . 'application/fonts/DancingScript-Regular.ttf'; // make sure font exists
            if (file_exists($font)) {
                imagettftext($im, 32, 0, 20, 100, $color, $font, $text);
            } else {
                imagestring($im, 5, 20, 50, $text, $color);
            }

            $file_name = 'signature_' . $contract_id . '_' . time() . '.png';
            $signature_file_path = $upload_dir . $file_name;
            imagepng($im, $signature_file_path);
            imagedestroy($im);

            $signature_file_path = $upload_url . $file_name;
        }elseif (!empty($_FILES['signatureFile']['name'])) {
            $config['upload_path']   = $upload_dir;
            $config['allowed_types'] = 'jpg|jpeg|png';
            $config['file_name']     = 'signature_' . $contract_id . '_' . time();

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('signatureFile')) {
                $uploadData = $this->upload->data();
                $signature_file_path = $upload_url . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'success'  => false,
                    'error'    => $this->upload->display_errors(),
                    'csrfHash' => $this->security->get_csrf_hash()
                ]);
                return;
            }
        } else {
            echo json_encode([
                'success'  => false,
                'error'    => 'No signature provided',
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
            return;
        }

        // Save file path in DB
        $this->db->where('id', $contract_id);
        $updated = $this->db->update('tblhr_candidate_contracts', ['signature' => $signature_file_path]);

        if ($updated) {
            $this->load->model('candidate_client_model');
            $contract = $this->candidate_client_model->update_candidate_status($contract_id, 'processing');
            echo json_encode([
                'success'  => true,
                'signature'=> base_url($signature_file_path),
                'csrfHash' => $this->security->get_csrf_hash(),
                'contract_id' => $contract_id
            ]);
        } else {
            $error = $this->db->error();
            echo json_encode([
                'success'  => false,
                'error'    => $error['message'],
                'csrfHash' => $this->security->get_csrf_hash()
            ]);
        }
    }


}
