<?php

defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: HR
Description: Human Resources module
Version: 1.0.0
Requires at least: 2.3.*
*/

define('HR_MODULE_NAME', 'hr');
define('HR_ASSETS_PATH', 'modules/hr/assets');

hooks()->add_action('app_admin_head', 'hr_styles');
function hr_styles()
{
    echo '<link href="' . module_dir_url('hr', 'assets/css/style.css') . '" rel="stylesheet" type="text/css">';
}

/**
 * Register activation module hook
 */
register_activation_hook(HR_MODULE_NAME, 'hr_module_activation_hook');
function hr_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(HR_MODULE_NAME, [HR_MODULE_NAME]);

/**
 * Basic admin menu
 */
hooks()->add_action('admin_init', 'hr_module_init_menu_items');
function hr_module_init_menu_items()
{
    $CI = &get_instance();
    $CI->app_menu->add_sidebar_menu_item('hr-module', [
        'name'     => _l('hr'),
        'href'     => admin_url('hr/hr'),
        'position' => 50,
        'icon'     => 'fa fa-users',
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-candidates',
        'name'     => _l('hr_candidates'),
        'href'     => admin_url('hr/candidate'),
        'position' => 1,
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-contracts-template',
        'name'     => _l('hr_contracts_template'),
        'href'     => admin_url('hr/contract_template'),
        'position' => 2,
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-contracts',
        'name'     => _l('hr_contracts'),
        'href'     => admin_url('hr/contract'),
        'position' => 3,
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-assignments',
        'name'     => _l('hr_assignments'),
        'href'     => admin_url('hr/assignment'),
        'position' => 4,
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-certifications',
        'name'     => _l('hr_certifications'),
        'href'     => admin_url('hr/certification'),
        'position' => 5,
    ]);

    $CI->app_menu->add_sidebar_children_item('hr-module', [
        'slug'     => 'hr-email-templates',
        'name'     => _l('hr_email_templates'),
        'href'     => admin_url('hr/email_templates'),
        'position' => 6,
    ]);
}
