<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700"><?php echo e($title); ?></h4>
                <div class="_buttons mtop15">
                    <a href="<?php echo admin_url('hr/contract_template/create'); ?>" class="btn btn-info">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('hr_new_contract'); ?>
                    </a>
                </div>

                <div class="panel_s tw-mt-2">
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table dt-table table-contracts">
                                <thead>
                                <tr>
                                    <th><?php echo _l('Name'); ?></th>
                                    <th><?php echo _l('Creation Date'); ?></th>
                                    <th><?php echo _l('Created By'); ?></th>
                                    <th><?php echo _l('Last Modify'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; ?>
                                <?php foreach ($contracts as $row) { ?>
                                    <tr>
                                        <td><?php echo e($row['title']); ?>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('hr/contract_template/edit/' . $row['id']); ?>" title="<?php echo _l('edit'); ?>">Edit</a> | 
                                                <a href="<?php echo admin_url('hr/contract_template/delete/' . $row['id']); ?>" class="text-danger" title="<?php echo _l('delete'); ?>">Delete</a>
                                            </div>
                                        </td>
                                        <td><?php echo date('d/m/Y', strtotime($row['created_at'])); ?></td>
                                        <td><?php echo ucfirst($row['firstname'].' '.$row['lastname']); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($row['updated_at'])); ?></td>
                                    </tr>
                                <?php $i++; ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
